/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.loadbalancer;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.netflix.client.config.CommonClientConfigKey;
import com.netflix.client.config.IClientConfig;
import com.netflix.config.DynamicIntProperty;
import com.netflix.loadbalancer.ServerListUpdater;
import java.util.Date;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollingServerListUpdater
implements ServerListUpdater {
    private static final Logger logger = LoggerFactory.getLogger(PollingServerListUpdater.class);
    private static long LISTOFSERVERS_CACHE_UPDATE_DELAY = 1000L;
    private static int LISTOFSERVERS_CACHE_REPEAT_INTERVAL = 30000;
    private final AtomicBoolean isActive = new AtomicBoolean(false);
    private volatile long lastUpdated = System.currentTimeMillis();
    private final long initialDelayMs;
    private final long refreshIntervalMs;
    private volatile ScheduledFuture<?> scheduledFuture;

    private static ScheduledThreadPoolExecutor getRefreshExecutor() {
        return LazyHolder._serverListRefreshExecutor;
    }

    public PollingServerListUpdater() {
        this(LISTOFSERVERS_CACHE_UPDATE_DELAY, LISTOFSERVERS_CACHE_REPEAT_INTERVAL);
    }

    public PollingServerListUpdater(IClientConfig clientConfig) {
        this(LISTOFSERVERS_CACHE_UPDATE_DELAY, PollingServerListUpdater.getRefreshIntervalMs(clientConfig));
    }

    public PollingServerListUpdater(long initialDelayMs, long refreshIntervalMs) {
        this.initialDelayMs = initialDelayMs;
        this.refreshIntervalMs = refreshIntervalMs;
    }

    @Override
    public synchronized void start(final ServerListUpdater.UpdateAction updateAction) {
        if (this.isActive.compareAndSet(false, true)) {
            Runnable wrapperRunnable = new Runnable(){

                @Override
                public void run() {
                    if (!PollingServerListUpdater.this.isActive.get()) {
                        if (PollingServerListUpdater.this.scheduledFuture != null) {
                            PollingServerListUpdater.this.scheduledFuture.cancel(true);
                        }
                        return;
                    }
                    try {
                        updateAction.doUpdate();
                        PollingServerListUpdater.this.lastUpdated = System.currentTimeMillis();
                    }
                    catch (Exception e) {
                        logger.warn("Failed one update cycle", (Throwable)e);
                    }
                }
            };
            this.scheduledFuture = PollingServerListUpdater.getRefreshExecutor().scheduleWithFixedDelay(wrapperRunnable, this.initialDelayMs, this.refreshIntervalMs, TimeUnit.MILLISECONDS);
        } else {
            logger.info("Already active, no-op");
        }
    }

    @Override
    public synchronized void stop() {
        if (this.isActive.compareAndSet(true, false)) {
            if (this.scheduledFuture != null) {
                this.scheduledFuture.cancel(true);
            }
        } else {
            logger.info("Not active, no-op");
        }
    }

    @Override
    public String getLastUpdate() {
        return new Date(this.lastUpdated).toString();
    }

    @Override
    public long getDurationSinceLastUpdateMs() {
        return System.currentTimeMillis() - this.lastUpdated;
    }

    @Override
    public int getNumberMissedCycles() {
        if (!this.isActive.get()) {
            return 0;
        }
        return (int)((long)((int)(System.currentTimeMillis() - this.lastUpdated)) / this.refreshIntervalMs);
    }

    @Override
    public int getCoreThreads() {
        if (this.isActive.get() && PollingServerListUpdater.getRefreshExecutor() != null) {
            return PollingServerListUpdater.getRefreshExecutor().getCorePoolSize();
        }
        return 0;
    }

    private static long getRefreshIntervalMs(IClientConfig clientConfig) {
        return ((Integer)clientConfig.get(CommonClientConfigKey.ServerListRefreshInterval, (Object)LISTOFSERVERS_CACHE_REPEAT_INTERVAL)).intValue();
    }

    private static class LazyHolder {
        private static final String CORE_THREAD = "DynamicServerListLoadBalancer.ThreadPoolSize";
        private static final DynamicIntProperty poolSizeProp = new DynamicIntProperty("DynamicServerListLoadBalancer.ThreadPoolSize", 2);
        private static Thread _shutdownThread;
        static ScheduledThreadPoolExecutor _serverListRefreshExecutor;

        private LazyHolder() {
        }

        private static void shutdownExecutorPool() {
            if (_serverListRefreshExecutor != null) {
                _serverListRefreshExecutor.shutdown();
                if (_shutdownThread != null) {
                    try {
                        Runtime.getRuntime().removeShutdownHook(_shutdownThread);
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                }
            }
        }

        static {
            _serverListRefreshExecutor = null;
            int coreSize = poolSizeProp.get();
            ThreadFactory factory = new ThreadFactoryBuilder().setNameFormat("PollingServerListUpdater-%d").setDaemon(true).build();
            _serverListRefreshExecutor = new ScheduledThreadPoolExecutor(coreSize, factory);
            poolSizeProp.addCallback(new Runnable(){

                @Override
                public void run() {
                    _serverListRefreshExecutor.setCorePoolSize(poolSizeProp.get());
                }
            });
            _shutdownThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    logger.info("Shutting down the Executor Pool for PollingServerListUpdater");
                    LazyHolder.shutdownExecutorPool();
                }
            });
            Runtime.getRuntime().addShutdownHook(_shutdownThread);
        }
    }
}

