/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.loadbalancer;

import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.AbstractLoadBalancerRule;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.IRule;
import com.netflix.loadbalancer.InterruptTask;
import com.netflix.loadbalancer.RoundRobinRule;
import com.netflix.loadbalancer.Server;

public class RetryRule
extends AbstractLoadBalancerRule {
    IRule subRule = new RoundRobinRule();
    long maxRetryMillis = 500L;

    public RetryRule() {
    }

    public RetryRule(IRule subRule) {
        this.subRule = subRule != null ? subRule : new RoundRobinRule();
    }

    public RetryRule(IRule subRule, long maxRetryMillis) {
        this.subRule = subRule != null ? subRule : new RoundRobinRule();
        this.maxRetryMillis = maxRetryMillis > 0L ? maxRetryMillis : 500L;
    }

    public void setRule(IRule subRule) {
        this.subRule = subRule != null ? subRule : new RoundRobinRule();
    }

    public IRule getRule() {
        return this.subRule;
    }

    public void setMaxRetryMillis(long maxRetryMillis) {
        this.maxRetryMillis = maxRetryMillis > 0L ? maxRetryMillis : 500L;
    }

    public long getMaxRetryMillis() {
        return this.maxRetryMillis;
    }

    @Override
    public void setLoadBalancer(ILoadBalancer lb) {
        super.setLoadBalancer(lb);
        this.subRule.setLoadBalancer(lb);
    }

    public Server choose(ILoadBalancer lb, Object key) {
        long requestTime = System.currentTimeMillis();
        long deadline = requestTime + this.maxRetryMillis;
        Server answer = null;
        answer = this.subRule.choose(key);
        if (!(answer != null && answer.isAlive() || System.currentTimeMillis() >= deadline)) {
            InterruptTask task = new InterruptTask(deadline - System.currentTimeMillis());
            while (!(Thread.interrupted() || (answer = this.subRule.choose(key)) != null && answer.isAlive() || System.currentTimeMillis() >= deadline)) {
                Thread.yield();
            }
            task.cancel();
        }
        if (answer == null || !answer.isAlive()) {
            return null;
        }
        return answer;
    }

    @Override
    public Server choose(Object key) {
        return this.choose(this.getLoadBalancer(), key);
    }

    public void initWithNiwsConfig(IClientConfig clientConfig) {
    }
}

