/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.loadbalancer;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.netflix.client.IClientConfigAware;
import com.netflix.client.config.CommonClientConfigKey;
import com.netflix.client.config.IClientConfig;
import com.netflix.client.config.IClientConfigKey;
import com.netflix.client.config.Property;
import com.netflix.loadbalancer.LoadBalancerStats;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.ServerStats;
import com.netflix.loadbalancer.ZoneAffinityServerListFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;

public class ServerListSubsetFilter<T extends Server>
extends ZoneAffinityServerListFilter<T>
implements IClientConfigAware,
Comparator<T> {
    private Random random = new Random();
    private volatile Set<T> currentSubset = Sets.newHashSet();
    private Property<Integer> sizeProp;
    private Property<Float> eliminationPercent;
    private Property<Integer> eliminationFailureCountThreshold;
    private Property<Integer> eliminationConnectionCountThreshold;
    private static final IClientConfigKey<Integer> SIZE = new CommonClientConfigKey<Integer>("ServerListSubsetFilter.size", Integer.valueOf(20)){};
    private static final IClientConfigKey<Float> FORCE_ELIMINATE_PERCENT = new CommonClientConfigKey<Float>("ServerListSubsetFilter.forceEliminatePercent", Float.valueOf(0.1f)){};
    private static final IClientConfigKey<Integer> ELIMINATION_FAILURE_THRESHOLD = new CommonClientConfigKey<Integer>("ServerListSubsetFilter.eliminationFailureThresold", Integer.valueOf(0)){};
    private static final IClientConfigKey<Integer> ELIMINATION_CONNECTION_THRESHOLD = new CommonClientConfigKey<Integer>("ServerListSubsetFilter.eliminationConnectionThresold", Integer.valueOf(0)){};

    @Deprecated
    public ServerListSubsetFilter() {
        this.sizeProp = Property.of((Object)SIZE.defaultValue());
        this.eliminationPercent = Property.of((Object)FORCE_ELIMINATE_PERCENT.defaultValue());
        this.eliminationFailureCountThreshold = Property.of((Object)ELIMINATION_FAILURE_THRESHOLD.defaultValue());
        this.eliminationConnectionCountThreshold = Property.of((Object)ELIMINATION_CONNECTION_THRESHOLD.defaultValue());
    }

    public ServerListSubsetFilter(IClientConfig clientConfig) {
        super(clientConfig);
        this.initWithNiwsConfig(clientConfig);
    }

    @Override
    public void initWithNiwsConfig(IClientConfig clientConfig) {
        this.sizeProp = clientConfig.getDynamicProperty(SIZE);
        this.eliminationPercent = clientConfig.getDynamicProperty(FORCE_ELIMINATE_PERCENT);
        this.eliminationFailureCountThreshold = clientConfig.getDynamicProperty(ELIMINATION_FAILURE_THRESHOLD);
        this.eliminationConnectionCountThreshold = clientConfig.getDynamicProperty(ELIMINATION_CONNECTION_THRESHOLD);
    }

    @Override
    public List<T> getFilteredListOfServers(List<T> servers) {
        List<T> zoneAffinityFiltered = super.getFilteredListOfServers(servers);
        HashSet candidates = Sets.newHashSet(zoneAffinityFiltered);
        HashSet newSubSet = Sets.newHashSet(this.currentSubset);
        LoadBalancerStats lbStats = this.getLoadBalancerStats();
        for (Server server : this.currentSubset) {
            if (!candidates.contains(server)) {
                newSubSet.remove(server);
                continue;
            }
            ServerStats stats = lbStats.getSingleServerStat(server);
            if (stats.getActiveRequestsCount() <= (Integer)this.eliminationConnectionCountThreshold.get() && stats.getFailureCount() <= (long)((Integer)this.eliminationFailureCountThreshold.get()).intValue()) continue;
            newSubSet.remove(server);
            candidates.remove(server);
        }
        int targetedListSize = (Integer)this.sizeProp.get();
        int numEliminated = this.currentSubset.size() - newSubSet.size();
        int minElimination = (int)((float)targetedListSize * ((Float)this.eliminationPercent.get()).floatValue());
        int numToForceEliminate = 0;
        if (targetedListSize < newSubSet.size()) {
            numToForceEliminate = newSubSet.size() - targetedListSize;
        } else if (minElimination > numEliminated) {
            numToForceEliminate = minElimination - numEliminated;
        }
        if (numToForceEliminate > newSubSet.size()) {
            numToForceEliminate = newSubSet.size();
        }
        if (numToForceEliminate > 0) {
            ArrayList sortedSubSet = Lists.newArrayList((Iterable)newSubSet);
            Collections.sort(sortedSubSet, this);
            List forceEliminated = sortedSubSet.subList(0, numToForceEliminate);
            newSubSet.removeAll(forceEliminated);
            candidates.removeAll(forceEliminated);
        }
        if (newSubSet.size() < targetedListSize) {
            int numToChoose = targetedListSize - newSubSet.size();
            candidates.removeAll(newSubSet);
            if (numToChoose > candidates.size()) {
                candidates = Sets.newHashSet(zoneAffinityFiltered);
                candidates.removeAll(newSubSet);
            }
            List<T> chosen = this.randomChoose(Lists.newArrayList((Iterable)candidates), numToChoose);
            for (Server server : chosen) {
                newSubSet.add(server);
            }
        }
        this.currentSubset = newSubSet;
        return Lists.newArrayList((Iterable)newSubSet);
    }

    private List<T> randomChoose(List<T> servers, int toChoose) {
        int size = servers.size();
        if (toChoose >= size || toChoose < 0) {
            return servers;
        }
        for (int i = 0; i < toChoose; ++i) {
            int index = this.random.nextInt(size);
            Server tmp = (Server)servers.get(index);
            servers.set(index, servers.get(i));
            servers.set(i, tmp);
        }
        return servers.subList(0, toChoose);
    }

    @Override
    public int compare(T server1, T server2) {
        LoadBalancerStats lbStats = this.getLoadBalancerStats();
        ServerStats stats1 = lbStats.getSingleServerStat((Server)server1);
        ServerStats stats2 = lbStats.getSingleServerStat((Server)server2);
        int failuresDiff = (int)(stats2.getFailureCount() - stats1.getFailureCount());
        if (failuresDiff != 0) {
            return failuresDiff;
        }
        return stats2.getActiveRequestsCount() - stats1.getActiveRequestsCount();
    }
}

