/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import rx.Notification;
import rx.Observable;
import rx.Observer;
import rx.Subscription;

public final class OperationMaterialize {
    public static <T> Observable.OnSubscribeFunc<Notification<T>> materialize(Observable<? extends T> sequence) {
        return new MaterializeObservable<T>(sequence);
    }

    private static class MaterializeObservable<T>
    implements Observable.OnSubscribeFunc<Notification<T>> {
        private final Observable<? extends T> sequence;

        public MaterializeObservable(Observable<? extends T> sequence) {
            this.sequence = sequence;
        }

        @Override
        public Subscription onSubscribe(final Observer<? super Notification<T>> observer) {
            return this.sequence.subscribe(new Observer<T>(){

                @Override
                public void onCompleted() {
                    observer.onNext(new Notification());
                    observer.onCompleted();
                }

                @Override
                public void onError(Throwable e) {
                    observer.onNext(new Notification(e));
                    observer.onCompleted();
                }

                @Override
                public void onNext(T value) {
                    observer.onNext(new Notification(value));
                }
            });
        }
    }
}

