/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.operators.SafeObservableSubscription;
import rx.operators.SynchronizedObserver;
import rx.subscriptions.CompositeSubscription;

public final class OperationMerge {
    public static <T> Observable.OnSubscribeFunc<T> merge(final Observable<? extends Observable<? extends T>> o) {
        return new Observable.OnSubscribeFunc<T>(){

            @Override
            public Subscription onSubscribe(Observer<? super T> observer) {
                return new MergeObservable(o).onSubscribe(observer);
            }
        };
    }

    public static <T> Observable.OnSubscribeFunc<T> merge(Observable<? extends T> ... sequences) {
        return OperationMerge.merge(Arrays.asList(sequences));
    }

    public static <T> Observable.OnSubscribeFunc<T> merge(final Iterable<? extends Observable<? extends T>> sequences) {
        return OperationMerge.merge(Observable.create(new Observable.OnSubscribeFunc<Observable<? extends T>>(){
            private volatile boolean unsubscribed = false;

            @Override
            public Subscription onSubscribe(Observer<? super Observable<? extends T>> observer) {
                for (Observable o : sequences) {
                    if (this.unsubscribed) break;
                    observer.onNext(o);
                }
                if (!this.unsubscribed) {
                    observer.onCompleted();
                }
                return new Subscription(){

                    @Override
                    public void unsubscribe() {
                        unsubscribed = true;
                    }
                };
            }
        }));
    }

    private static final class MergeObservable<T>
    implements Observable.OnSubscribeFunc<T> {
        private final Observable<? extends Observable<? extends T>> sequences;
        private final MergeSubscription ourSubscription = new MergeSubscription();
        private AtomicBoolean stopped = new AtomicBoolean(false);
        private volatile boolean parentCompleted = false;
        private final ConcurrentHashMap<ChildObserver, ChildObserver> childObservers = new ConcurrentHashMap();
        private final ConcurrentHashMap<ChildObserver, Subscription> childSubscriptions = new ConcurrentHashMap();

        private MergeObservable(Observable<? extends Observable<? extends T>> sequences) {
            this.sequences = sequences;
        }

        @Override
        public Subscription onSubscribe(Observer<? super T> actualObserver) {
            CompositeSubscription completeSubscription = new CompositeSubscription(new Subscription[0]);
            SafeObservableSubscription subscription = new SafeObservableSubscription(this.ourSubscription);
            completeSubscription.add(subscription);
            SynchronizedObserver<? super T> synchronizedObserver = new SynchronizedObserver<T>(actualObserver, subscription);
            completeSubscription.add(this.sequences.subscribe(new ParentObserver(synchronizedObserver)));
            return completeSubscription;
        }

        private class ChildObserver
        implements Observer<T> {
            private final Observer<T> actualObserver;

            public ChildObserver(Observer<T> actualObserver) {
                this.actualObserver = actualObserver;
            }

            @Override
            public void onCompleted() {
                MergeObservable.this.childObservers.remove(this);
                if (!MergeObservable.this.stopped.get() && MergeObservable.this.childObservers.size() == 0 && MergeObservable.this.parentCompleted && MergeObservable.this.ourSubscription.stop()) {
                    this.actualObserver.onCompleted();
                }
            }

            @Override
            public void onError(Throwable e) {
                if (!MergeObservable.this.stopped.get() && MergeObservable.this.ourSubscription.stop()) {
                    this.actualObserver.onError(e);
                }
            }

            @Override
            public void onNext(T args) {
                if (!MergeObservable.this.stopped.get()) {
                    this.actualObserver.onNext(args);
                }
            }
        }

        private class ParentObserver
        implements Observer<Observable<? extends T>> {
            private final Observer<T> actualObserver;

            public ParentObserver(Observer<T> actualObserver) {
                this.actualObserver = actualObserver;
            }

            @Override
            public void onCompleted() {
                MergeObservable.this.parentCompleted = true;
                if (MergeObservable.this.childObservers.size() == 0 && !MergeObservable.this.stopped.get() && MergeObservable.this.ourSubscription.stop()) {
                    this.actualObserver.onCompleted();
                }
            }

            @Override
            public void onError(Throwable e) {
                this.actualObserver.onError(e);
            }

            @Override
            public void onNext(Observable<? extends T> childObservable) {
                if (MergeObservable.this.stopped.get()) {
                    return;
                }
                if (childObservable == null) {
                    throw new IllegalArgumentException("Observable<T> can not be null.");
                }
                ChildObserver _w = new ChildObserver(this.actualObserver);
                MergeObservable.this.childObservers.put(_w, _w);
                Subscription _subscription = childObservable.subscribe(_w);
                MergeObservable.this.childSubscriptions.put(_w, _subscription);
            }
        }

        private class MergeSubscription
        implements Subscription {
            private MergeSubscription() {
            }

            @Override
            public void unsubscribe() {
                this.stop();
            }

            public boolean stop() {
                boolean didSet = MergeObservable.this.stopped.compareAndSet(false, true);
                if (didSet) {
                    for (Subscription _s : MergeObservable.this.childSubscriptions.values()) {
                        _s.unsubscribe();
                    }
                    return true;
                }
                return false;
            }
        }
    }
}

