/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import rx.Observable;
import rx.Observer;
import rx.Scheduler;
import rx.Subscription;
import rx.concurrency.Schedulers;
import rx.operators.OperationInterval;
import rx.subscriptions.Subscriptions;
import rx.util.functions.Action0;

public final class OperationSample {
    public static <T> Observable.OnSubscribeFunc<T> sample(Observable<? extends T> source, long period, TimeUnit unit) {
        return new Sample(source, period, unit, Schedulers.threadPoolForComputation());
    }

    public static <T> Observable.OnSubscribeFunc<T> sample(Observable<? extends T> source, long period, TimeUnit unit, Scheduler scheduler) {
        return new Sample(source, period, unit, scheduler);
    }

    private static class Sample<T>
    implements Observable.OnSubscribeFunc<T> {
        private final Observable<? extends T> source;
        private final long period;
        private final TimeUnit unit;
        private final Scheduler scheduler;
        private final AtomicBoolean hasValue = new AtomicBoolean();
        private final AtomicReference<T> latestValue = new AtomicReference();

        private Sample(Observable<? extends T> source, long interval, TimeUnit unit, Scheduler scheduler) {
            this.source = source;
            this.period = interval;
            this.unit = unit;
            this.scheduler = scheduler;
        }

        @Override
        public Subscription onSubscribe(final Observer<? super T> observer) {
            Observable<Long> clock = Observable.create(OperationInterval.interval(this.period, this.unit, this.scheduler));
            final Subscription clockSubscription = clock.subscribe(new Observer<Long>(){

                @Override
                public void onCompleted() {
                }

                @Override
                public void onError(Throwable e) {
                }

                @Override
                public void onNext(Long tick) {
                    if (Sample.this.hasValue.get()) {
                        observer.onNext(Sample.this.latestValue.get());
                    }
                }
            });
            final Subscription sourceSubscription = this.source.subscribe(new Observer<T>(){

                @Override
                public void onCompleted() {
                    clockSubscription.unsubscribe();
                    observer.onCompleted();
                }

                @Override
                public void onError(Throwable e) {
                    clockSubscription.unsubscribe();
                    observer.onError(e);
                }

                @Override
                public void onNext(T value) {
                    Sample.this.latestValue.set(value);
                    Sample.this.hasValue.set(true);
                }
            });
            return Subscriptions.create(new Action0(){

                @Override
                public void call() {
                    clockSubscription.unsubscribe();
                    sourceSubscription.unsubscribe();
                }
            });
        }
    }
}

