/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.util.functions.Func1;
import rx.util.functions.Func2;

public final class OperationSkipWhile {
    public static <T> Observable.OnSubscribeFunc<T> skipWhileWithIndex(Observable<? extends T> source, Func2<? super T, Integer, Boolean> predicate) {
        return new SkipWhile<T>(source, predicate);
    }

    public static <T> Observable.OnSubscribeFunc<T> skipWhile(Observable<? extends T> source, final Func1<? super T, Boolean> predicate) {
        return new SkipWhile<T>(source, new Func2<T, Integer, Boolean>(){

            @Override
            public Boolean call(T value, Integer index) {
                return (Boolean)predicate.call(value);
            }
        });
    }

    private static class SkipWhile<T>
    implements Observable.OnSubscribeFunc<T> {
        private final Observable<? extends T> source;
        private final Func2<? super T, Integer, Boolean> predicate;
        private final AtomicBoolean skipping = new AtomicBoolean(true);
        private final AtomicInteger index = new AtomicInteger(0);

        SkipWhile(Observable<? extends T> source, Func2<? super T, Integer, Boolean> pred) {
            this.source = source;
            this.predicate = pred;
        }

        @Override
        public Subscription onSubscribe(Observer<? super T> observer) {
            return this.source.subscribe(new SkipWhileObserver(observer));
        }

        private class SkipWhileObserver
        implements Observer<T> {
            private final Observer<? super T> observer;

            public SkipWhileObserver(Observer<? super T> observer) {
                this.observer = observer;
            }

            @Override
            public void onCompleted() {
                this.observer.onCompleted();
            }

            @Override
            public void onError(Throwable e) {
                this.observer.onError(e);
            }

            @Override
            public void onNext(T next) {
                if (!SkipWhile.this.skipping.get()) {
                    this.observer.onNext(next);
                } else {
                    try {
                        if (!((Boolean)SkipWhile.this.predicate.call(next, SkipWhile.this.index.getAndIncrement())).booleanValue()) {
                            SkipWhile.this.skipping.set(false);
                            this.observer.onNext(next);
                        }
                    }
                    catch (Throwable t) {
                        this.observer.onError(t);
                    }
                }
            }
        }
    }
}

