/*
 * Decompiled with CFR 0.152.
 */
package rx;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import rx.Subscription;
import rx.concurrency.TestScheduler;
import rx.subscriptions.Subscriptions;
import rx.util.functions.Action0;
import rx.util.functions.Func1;
import rx.util.functions.Func2;

public abstract class Scheduler {
    public abstract <T> Subscription schedule(T var1, Func2<? super Scheduler, ? super T, ? extends Subscription> var2);

    public abstract <T> Subscription schedule(T var1, Func2<? super Scheduler, ? super T, ? extends Subscription> var2, long var3, TimeUnit var5);

    public <T> Subscription schedulePeriodically(T state, final Func2<? super Scheduler, ? super T, ? extends Subscription> action, long initialDelay, long period, TimeUnit unit) {
        final long periodInNanos = unit.toNanos(period);
        final AtomicBoolean complete = new AtomicBoolean();
        Func2 recursiveAction = new Func2<Scheduler, T, Subscription>(){

            @Override
            public Subscription call(Scheduler scheduler, T state0) {
                if (!complete.get()) {
                    long startedAt = Scheduler.this.now();
                    final Subscription sub1 = (Subscription)action.call(scheduler, state0);
                    long timeTakenByActionInNanos = TimeUnit.MILLISECONDS.toNanos(Scheduler.this.now() - startedAt);
                    final Subscription sub2 = Scheduler.this.schedule(state0, this, periodInNanos - timeTakenByActionInNanos, TimeUnit.NANOSECONDS);
                    return Subscriptions.create(new Action0(){

                        @Override
                        public void call() {
                            sub1.unsubscribe();
                            sub2.unsubscribe();
                        }
                    });
                }
                return Subscriptions.empty();
            }
        };
        final Subscription sub = this.schedule(state, recursiveAction, initialDelay, unit);
        return Subscriptions.create(new Action0(){

            @Override
            public void call() {
                complete.set(true);
                sub.unsubscribe();
            }
        });
    }

    public <T> Subscription schedule(T state, Func2<? super Scheduler, ? super T, ? extends Subscription> action, Date dueTime) {
        long scheduledTime = dueTime.getTime();
        long timeInFuture = scheduledTime - this.now();
        if (timeInFuture <= 0L) {
            return this.schedule(state, action);
        }
        return this.schedule(state, action, timeInFuture, TimeUnit.MILLISECONDS);
    }

    public Subscription schedule(final Action0 action) {
        return this.schedule(null, new Func2<Scheduler, Void, Subscription>(){

            @Override
            public Subscription call(Scheduler scheduler, Void state) {
                action.call();
                return Subscriptions.empty();
            }
        });
    }

    public Subscription schedule(final Action0 action, long delayTime, TimeUnit unit) {
        return this.schedule(null, new Func2<Scheduler, Void, Subscription>(){

            @Override
            public Subscription call(Scheduler scheduler, Void state) {
                action.call();
                return Subscriptions.empty();
            }
        }, delayTime, unit);
    }

    public Subscription schedulePeriodically(final Action0 action, long initialDelay, long period, TimeUnit unit) {
        return this.schedulePeriodically(null, new Func2<Scheduler, Void, Subscription>(){

            @Override
            public Subscription call(Scheduler scheduler, Void state) {
                action.call();
                return Subscriptions.empty();
            }
        }, initialDelay, period, unit);
    }

    public long now() {
        return System.currentTimeMillis();
    }

    public int degreeOfParallelism() {
        return Runtime.getRuntime().availableProcessors();
    }

    public static class UnitTest {
        @Test
        public void testPeriodicScheduling() {
            final Func1 calledOp = (Func1)Mockito.mock(Func1.class);
            final TestScheduler scheduler = new TestScheduler();
            Subscription subscription = scheduler.schedulePeriodically(new Action0(){

                @Override
                public void call() {
                    System.out.println(scheduler.now());
                    calledOp.call(scheduler.now());
                }
            }, 1L, 2L, TimeUnit.SECONDS);
            ((Func1)Mockito.verify((Object)calledOp, (VerificationMode)Mockito.never())).call(Mockito.anyLong());
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{calledOp});
            scheduler.advanceTimeBy(999L, TimeUnit.MILLISECONDS);
            ((Func1)inOrder.verify((Object)calledOp, Mockito.never())).call(Mockito.anyLong());
            scheduler.advanceTimeBy(1L, TimeUnit.MILLISECONDS);
            ((Func1)inOrder.verify((Object)calledOp, Mockito.times((int)1))).call(1000L);
            scheduler.advanceTimeBy(1999L, TimeUnit.MILLISECONDS);
            ((Func1)inOrder.verify((Object)calledOp, Mockito.never())).call(3000L);
            scheduler.advanceTimeBy(1L, TimeUnit.MILLISECONDS);
            ((Func1)inOrder.verify((Object)calledOp, Mockito.times((int)1))).call(3000L);
            scheduler.advanceTimeBy(5L, TimeUnit.SECONDS);
            ((Func1)inOrder.verify((Object)calledOp, Mockito.times((int)1))).call(5000L);
            ((Func1)inOrder.verify((Object)calledOp, Mockito.times((int)1))).call(7000L);
            subscription.unsubscribe();
            scheduler.advanceTimeBy(11L, TimeUnit.SECONDS);
            ((Func1)inOrder.verify((Object)calledOp, Mockito.never())).call(Mockito.anyLong());
        }
    }
}

