/*
 * Decompiled with CFR 0.152.
 */
package rx.concurrency;

import java.util.concurrent.TimeUnit;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import rx.Scheduler;
import rx.Subscription;
import rx.concurrency.SleepingAction;
import rx.util.functions.Action0;
import rx.util.functions.Func2;

public final class ImmediateScheduler
extends Scheduler {
    private static final ImmediateScheduler INSTANCE = new ImmediateScheduler();

    public static ImmediateScheduler getInstance() {
        return INSTANCE;
    }

    private ImmediateScheduler() {
    }

    @Override
    public <T> Subscription schedule(T state, Func2<? super Scheduler, ? super T, ? extends Subscription> action) {
        return action.call(this, state);
    }

    @Override
    public <T> Subscription schedule(T state, Func2<? super Scheduler, ? super T, ? extends Subscription> action, long dueTime, TimeUnit unit) {
        long execTime = this.now() + unit.toMillis(dueTime);
        return this.schedule(state, new SleepingAction<T>(action, this, execTime));
    }

    public static class UnitTest {
        @Test
        public void testNestedActions() {
            final ImmediateScheduler scheduler = new ImmediateScheduler();
            final Action0 firstStepStart = (Action0)Mockito.mock(Action0.class);
            final Action0 firstStepEnd = (Action0)Mockito.mock(Action0.class);
            final Action0 secondStepStart = (Action0)Mockito.mock(Action0.class);
            final Action0 secondStepEnd = (Action0)Mockito.mock(Action0.class);
            final Action0 thirdStepStart = (Action0)Mockito.mock(Action0.class);
            final Action0 thirdStepEnd = (Action0)Mockito.mock(Action0.class);
            final Action0 firstAction = new Action0(){

                @Override
                public void call() {
                    firstStepStart.call();
                    firstStepEnd.call();
                }
            };
            final Action0 secondAction = new Action0(){

                @Override
                public void call() {
                    secondStepStart.call();
                    scheduler.schedule(firstAction);
                    secondStepEnd.call();
                }
            };
            Action0 thirdAction = new Action0(){

                @Override
                public void call() {
                    thirdStepStart.call();
                    scheduler.schedule(secondAction);
                    thirdStepEnd.call();
                }
            };
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{firstStepStart, firstStepEnd, secondStepStart, secondStepEnd, thirdStepStart, thirdStepEnd});
            scheduler.schedule(thirdAction);
            ((Action0)inOrder.verify((Object)thirdStepStart, Mockito.times((int)1))).call();
            ((Action0)inOrder.verify((Object)secondStepStart, Mockito.times((int)1))).call();
            ((Action0)inOrder.verify((Object)firstStepStart, Mockito.times((int)1))).call();
            ((Action0)inOrder.verify((Object)firstStepEnd, Mockito.times((int)1))).call();
            ((Action0)inOrder.verify((Object)secondStepEnd, Mockito.times((int)1))).call();
            ((Action0)inOrder.verify((Object)thirdStepEnd, Mockito.times((int)1))).call();
        }
    }
}

