/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Test;
import org.mockito.Mockito;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.operators.SafeObservableSubscription;
import rx.util.functions.Func1;

public class OperationAll {
    public static <T> Observable.OnSubscribeFunc<Boolean> all(Observable<? extends T> sequence, Func1<? super T, Boolean> predicate) {
        return new AllObservable(sequence, predicate);
    }

    public static class UnitTest {
        @Test
        public void testAll() {
            Observable<String> obs = Observable.from("one", "two", "six");
            Observer observer = (Observer)Mockito.mock(Observer.class);
            Observable.create(OperationAll.all(obs, new Func1<String, Boolean>(){

                @Override
                public Boolean call(String s) {
                    return s.length() == 3;
                }
            })).subscribe(observer);
            ((Observer)Mockito.verify((Object)observer)).onNext(true);
            ((Observer)Mockito.verify((Object)observer)).onCompleted();
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{observer});
        }

        @Test
        public void testNotAll() {
            Observable<String> obs = Observable.from("one", "two", "three", "six");
            Observer observer = (Observer)Mockito.mock(Observer.class);
            Observable.create(OperationAll.all(obs, new Func1<String, Boolean>(){

                @Override
                public Boolean call(String s) {
                    return s.length() == 3;
                }
            })).subscribe(observer);
            ((Observer)Mockito.verify((Object)observer)).onNext(false);
            ((Observer)Mockito.verify((Object)observer)).onCompleted();
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{observer});
        }

        @Test
        public void testEmpty() {
            Observable obs = Observable.empty();
            Observer observer = (Observer)Mockito.mock(Observer.class);
            Observable.create(OperationAll.all(obs, new Func1<String, Boolean>(){

                @Override
                public Boolean call(String s) {
                    return s.length() == 3;
                }
            })).subscribe(observer);
            ((Observer)Mockito.verify((Object)observer)).onNext(true);
            ((Observer)Mockito.verify((Object)observer)).onCompleted();
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{observer});
        }

        @Test
        public void testError() {
            Throwable error = new Throwable();
            Observable obs = Observable.error(error);
            Observer observer = (Observer)Mockito.mock(Observer.class);
            Observable.create(OperationAll.all(obs, new Func1<String, Boolean>(){

                @Override
                public Boolean call(String s) {
                    return s.length() == 3;
                }
            })).subscribe(observer);
            ((Observer)Mockito.verify((Object)observer)).onError(error);
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{observer});
        }
    }

    private static class AllObservable<T>
    implements Observable.OnSubscribeFunc<Boolean> {
        private final Observable<? extends T> sequence;
        private final Func1<? super T, Boolean> predicate;
        private final SafeObservableSubscription subscription = new SafeObservableSubscription();

        private AllObservable(Observable<? extends T> sequence, Func1<? super T, Boolean> predicate) {
            this.sequence = sequence;
            this.predicate = predicate;
        }

        @Override
        public Subscription onSubscribe(Observer<? super Boolean> observer) {
            return this.subscription.wrap(this.sequence.subscribe(new AllObserver(observer)));
        }

        private class AllObserver
        implements Observer<T> {
            private final Observer<? super Boolean> underlying;
            private final AtomicBoolean status = new AtomicBoolean(true);

            public AllObserver(Observer<? super Boolean> underlying) {
                this.underlying = underlying;
            }

            @Override
            public void onCompleted() {
                if (this.status.get()) {
                    this.underlying.onNext((Boolean)true);
                    this.underlying.onCompleted();
                }
            }

            @Override
            public void onError(Throwable e) {
                this.underlying.onError(e);
            }

            @Override
            public void onNext(T args) {
                boolean result = (Boolean)AllObservable.this.predicate.call(args);
                boolean changed = this.status.compareAndSet(true, result);
                if (changed && !result) {
                    this.underlying.onNext((Boolean)false);
                    this.underlying.onCompleted();
                    AllObservable.this.subscription.unsubscribe();
                }
            }
        }
    }
}

