/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import rx.Observable;
import rx.Observer;
import rx.util.functions.Func1;
import rx.util.functions.Func2;

public final class OperationAverage {
    public static Observable<Integer> average(Observable<Integer> source) {
        return source.reduce(new Tuple2(0, 0), new Func2<Tuple2<Integer>, Integer, Tuple2<Integer>>(){

            @Override
            public Tuple2<Integer> call(Tuple2<Integer> accu, Integer next) {
                return new Tuple2<Integer>((Integer)((Tuple2)accu).current + next, ((Tuple2)accu).count + 1);
            }
        }).map(new Func1<Tuple2<Integer>, Integer>(){

            @Override
            public Integer call(Tuple2<Integer> result) {
                return (Integer)((Tuple2)result).current / ((Tuple2)result).count;
            }
        });
    }

    public static Observable<Long> averageLongs(Observable<Long> source) {
        return source.reduce(new Tuple2(0L, 0), new Func2<Tuple2<Long>, Long, Tuple2<Long>>(){

            @Override
            public Tuple2<Long> call(Tuple2<Long> accu, Long next) {
                return new Tuple2<Long>((Long)((Tuple2)accu).current + next, ((Tuple2)accu).count + 1);
            }
        }).map(new Func1<Tuple2<Long>, Long>(){

            @Override
            public Long call(Tuple2<Long> result) {
                return (Long)((Tuple2)result).current / (long)((Tuple2)result).count.intValue();
            }
        });
    }

    public static Observable<Float> averageFloats(Observable<Float> source) {
        return source.reduce(new Tuple2(Float.valueOf(0.0f), 0), new Func2<Tuple2<Float>, Float, Tuple2<Float>>(){

            @Override
            public Tuple2<Float> call(Tuple2<Float> accu, Float next) {
                return new Tuple2<Float>(Float.valueOf(((Float)((Tuple2)accu).current).floatValue() + next.floatValue()), ((Tuple2)accu).count + 1);
            }
        }).map(new Func1<Tuple2<Float>, Float>(){

            @Override
            public Float call(Tuple2<Float> result) {
                if (((Tuple2)result).count == 0) {
                    throw new ArithmeticException("divide by zero");
                }
                return Float.valueOf(((Float)((Tuple2)result).current).floatValue() / (float)((Tuple2)result).count.intValue());
            }
        });
    }

    public static Observable<Double> averageDoubles(Observable<Double> source) {
        return source.reduce(new Tuple2(0.0, 0), new Func2<Tuple2<Double>, Double, Tuple2<Double>>(){

            @Override
            public Tuple2<Double> call(Tuple2<Double> accu, Double next) {
                return new Tuple2<Double>((Double)((Tuple2)accu).current + next, ((Tuple2)accu).count + 1);
            }
        }).map(new Func1<Tuple2<Double>, Double>(){

            @Override
            public Double call(Tuple2<Double> result) {
                if (((Tuple2)result).count == 0) {
                    throw new ArithmeticException("divide by zero");
                }
                return (Double)((Tuple2)result).current / (double)((Tuple2)result).count.intValue();
            }
        });
    }

    public static class UnitTest {
        Observer<Integer> w = (Observer)Mockito.mock(Observer.class);
        Observer<Long> wl = (Observer)Mockito.mock(Observer.class);
        Observer<Float> wf = (Observer)Mockito.mock(Observer.class);
        Observer<Double> wd = (Observer)Mockito.mock(Observer.class);

        @Test
        public void testAverageOfAFewInts() throws Throwable {
            Observable<Integer> src = Observable.from(1, 2, 3, 4, 6);
            OperationAverage.average(src).subscribe(this.w);
            ((Observer)Mockito.verify(this.w, (VerificationMode)Mockito.times((int)1))).onNext(Mockito.anyInt());
            ((Observer)Mockito.verify(this.w)).onNext(3);
            ((Observer)Mockito.verify(this.w, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify(this.w, (VerificationMode)Mockito.times((int)1))).onCompleted();
        }

        @Test
        public void testEmptyAverage() throws Throwable {
            Observable<Integer> src = Observable.empty();
            OperationAverage.average(src).subscribe(this.w);
            ((Observer)Mockito.verify(this.w, (VerificationMode)Mockito.never())).onNext(Mockito.anyInt());
            ((Observer)Mockito.verify(this.w, (VerificationMode)Mockito.times((int)1))).onError((Throwable)Mockito.any(ArithmeticException.class));
            ((Observer)Mockito.verify(this.w, (VerificationMode)Mockito.never())).onCompleted();
        }

        @Test
        public void testAverageOfAFewLongs() throws Throwable {
            Observable<Long> src = Observable.from(1L, 2L, 3L, 4L, 6L);
            OperationAverage.averageLongs(src).subscribe(this.wl);
            ((Observer)Mockito.verify(this.wl, (VerificationMode)Mockito.times((int)1))).onNext(Mockito.anyLong());
            ((Observer)Mockito.verify(this.wl)).onNext(3L);
            ((Observer)Mockito.verify(this.wl, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify(this.wl, (VerificationMode)Mockito.times((int)1))).onCompleted();
        }

        @Test
        public void testEmptyAverageLongs() throws Throwable {
            Observable<Long> src = Observable.empty();
            OperationAverage.averageLongs(src).subscribe(this.wl);
            ((Observer)Mockito.verify(this.wl, (VerificationMode)Mockito.never())).onNext(Mockito.anyLong());
            ((Observer)Mockito.verify(this.wl, (VerificationMode)Mockito.times((int)1))).onError((Throwable)Mockito.any(ArithmeticException.class));
            ((Observer)Mockito.verify(this.wl, (VerificationMode)Mockito.never())).onCompleted();
        }

        @Test
        public void testAverageOfAFewFloats() throws Throwable {
            Observable<Float> src = Observable.from(Float.valueOf(1.0f), Float.valueOf(2.0f));
            OperationAverage.averageFloats(src).subscribe(this.wf);
            ((Observer)Mockito.verify(this.wf, (VerificationMode)Mockito.times((int)1))).onNext(Float.valueOf(Mockito.anyFloat()));
            ((Observer)Mockito.verify(this.wf)).onNext(Float.valueOf(1.5f));
            ((Observer)Mockito.verify(this.wf, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify(this.wf, (VerificationMode)Mockito.times((int)1))).onCompleted();
        }

        @Test
        public void testEmptyAverageFloats() throws Throwable {
            Observable<Float> src = Observable.empty();
            OperationAverage.averageFloats(src).subscribe(this.wf);
            ((Observer)Mockito.verify(this.wf, (VerificationMode)Mockito.never())).onNext(Float.valueOf(Mockito.anyFloat()));
            ((Observer)Mockito.verify(this.wf, (VerificationMode)Mockito.times((int)1))).onError((Throwable)Mockito.any(ArithmeticException.class));
            ((Observer)Mockito.verify(this.wf, (VerificationMode)Mockito.never())).onCompleted();
        }

        @Test
        public void testAverageOfAFewDoubles() throws Throwable {
            Observable<Double> src = Observable.from(1.0, 2.0);
            OperationAverage.averageDoubles(src).subscribe(this.wd);
            ((Observer)Mockito.verify(this.wd, (VerificationMode)Mockito.times((int)1))).onNext(Mockito.anyDouble());
            ((Observer)Mockito.verify(this.wd)).onNext(1.5);
            ((Observer)Mockito.verify(this.wd, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify(this.wd, (VerificationMode)Mockito.times((int)1))).onCompleted();
        }

        @Test
        public void testEmptyAverageDoubles() throws Throwable {
            Observable<Double> src = Observable.empty();
            OperationAverage.averageDoubles(src).subscribe(this.wd);
            ((Observer)Mockito.verify(this.wd, (VerificationMode)Mockito.never())).onNext(Mockito.anyDouble());
            ((Observer)Mockito.verify(this.wd, (VerificationMode)Mockito.times((int)1))).onError((Throwable)Mockito.any(ArithmeticException.class));
            ((Observer)Mockito.verify(this.wd, (VerificationMode)Mockito.never())).onCompleted();
        }
    }

    private static final class Tuple2<T> {
        private final T current;
        private final Integer count;

        private Tuple2(T v1, Integer v2) {
            this.current = v1;
            this.count = v2;
        }
    }
}

