/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import rx.Observable;
import rx.Observer;
import rx.Scheduler;
import rx.Subscription;
import rx.concurrency.Schedulers;
import rx.concurrency.TestScheduler;
import rx.operators.ChunkedOperation;
import rx.subscriptions.Subscriptions;
import rx.util.Closing;
import rx.util.Closings;
import rx.util.Opening;
import rx.util.Openings;
import rx.util.functions.Action0;
import rx.util.functions.Func0;
import rx.util.functions.Func1;

public final class OperationBuffer
extends ChunkedOperation {
    private static <T> Func0<Buffer<T>> bufferMaker() {
        return new Func0<Buffer<T>>(){

            @Override
            public Buffer<T> call() {
                return new Buffer();
            }
        };
    }

    public static <T> Observable.OnSubscribeFunc<List<T>> buffer(final Observable<T> source, final Func0<? extends Observable<? extends Closing>> bufferClosingSelector) {
        return new Observable.OnSubscribeFunc<List<T>>(){

            @Override
            public Subscription onSubscribe(Observer<? super List<T>> observer) {
                ChunkedOperation.NonOverlappingChunks buffers = new ChunkedOperation.NonOverlappingChunks(observer, OperationBuffer.bufferMaker());
                ChunkedOperation.ObservableBasedSingleChunkCreator creator = new ChunkedOperation.ObservableBasedSingleChunkCreator(buffers, bufferClosingSelector);
                return source.subscribe(new ChunkedOperation.ChunkObserver(buffers, observer, creator));
            }
        };
    }

    public static <T> Observable.OnSubscribeFunc<List<T>> buffer(final Observable<T> source, final Observable<? extends Opening> bufferOpenings, final Func1<Opening, ? extends Observable<? extends Closing>> bufferClosingSelector) {
        return new Observable.OnSubscribeFunc<List<T>>(){

            @Override
            public Subscription onSubscribe(Observer<? super List<T>> observer) {
                ChunkedOperation.OverlappingChunks buffers = new ChunkedOperation.OverlappingChunks(observer, OperationBuffer.bufferMaker());
                ChunkedOperation.ObservableBasedMultiChunkCreator creator = new ChunkedOperation.ObservableBasedMultiChunkCreator(buffers, bufferOpenings, bufferClosingSelector);
                return source.subscribe(new ChunkedOperation.ChunkObserver(buffers, observer, creator));
            }
        };
    }

    public static <T> Observable.OnSubscribeFunc<List<T>> buffer(Observable<T> source, int count) {
        return OperationBuffer.buffer(source, count, count);
    }

    public static <T> Observable.OnSubscribeFunc<List<T>> buffer(final Observable<T> source, final int count, final int skip) {
        return new Observable.OnSubscribeFunc<List<T>>(){

            @Override
            public Subscription onSubscribe(Observer<? super List<T>> observer) {
                ChunkedOperation.SizeBasedChunks chunks = new ChunkedOperation.SizeBasedChunks(observer, OperationBuffer.bufferMaker(), count);
                ChunkedOperation.SkippingChunkCreator creator = new ChunkedOperation.SkippingChunkCreator(chunks, skip);
                return source.subscribe(new ChunkedOperation.ChunkObserver(chunks, observer, creator));
            }
        };
    }

    public static <T> Observable.OnSubscribeFunc<List<T>> buffer(Observable<T> source, long timespan, TimeUnit unit) {
        return OperationBuffer.buffer(source, timespan, unit, Schedulers.threadPoolForComputation());
    }

    public static <T> Observable.OnSubscribeFunc<List<T>> buffer(final Observable<T> source, final long timespan, final TimeUnit unit, final Scheduler scheduler) {
        return new Observable.OnSubscribeFunc<List<T>>(){

            @Override
            public Subscription onSubscribe(Observer<? super List<T>> observer) {
                ChunkedOperation.NonOverlappingChunks buffers = new ChunkedOperation.NonOverlappingChunks(observer, OperationBuffer.bufferMaker());
                ChunkedOperation.TimeBasedChunkCreator creator = new ChunkedOperation.TimeBasedChunkCreator(buffers, timespan, unit, scheduler);
                return source.subscribe(new ChunkedOperation.ChunkObserver(buffers, observer, creator));
            }
        };
    }

    public static <T> Observable.OnSubscribeFunc<List<T>> buffer(Observable<T> source, long timespan, TimeUnit unit, int count) {
        return OperationBuffer.buffer(source, timespan, unit, count, Schedulers.threadPoolForComputation());
    }

    public static <T> Observable.OnSubscribeFunc<List<T>> buffer(final Observable<T> source, final long timespan, final TimeUnit unit, final int count, final Scheduler scheduler) {
        return new Observable.OnSubscribeFunc<List<T>>(){

            @Override
            public Subscription onSubscribe(Observer<? super List<T>> observer) {
                ChunkedOperation.TimeAndSizeBasedChunks chunks = new ChunkedOperation.TimeAndSizeBasedChunks(observer, OperationBuffer.bufferMaker(), count, timespan, unit, scheduler);
                ChunkedOperation.SingleChunkCreator creator = new ChunkedOperation.SingleChunkCreator(chunks);
                return source.subscribe(new ChunkedOperation.ChunkObserver(chunks, observer, creator));
            }
        };
    }

    public static <T> Observable.OnSubscribeFunc<List<T>> buffer(Observable<T> source, long timespan, long timeshift, TimeUnit unit) {
        return OperationBuffer.buffer(source, timespan, timeshift, unit, Schedulers.threadPoolForComputation());
    }

    public static <T> Observable.OnSubscribeFunc<List<T>> buffer(final Observable<T> source, final long timespan, final long timeshift, final TimeUnit unit, final Scheduler scheduler) {
        return new Observable.OnSubscribeFunc<List<T>>(){

            @Override
            public Subscription onSubscribe(Observer<? super List<T>> observer) {
                ChunkedOperation.TimeBasedChunks buffers = new ChunkedOperation.TimeBasedChunks(observer, OperationBuffer.bufferMaker(), timespan, unit, scheduler);
                ChunkedOperation.TimeBasedChunkCreator creator = new ChunkedOperation.TimeBasedChunkCreator(buffers, timeshift, unit, scheduler);
                return source.subscribe(new ChunkedOperation.ChunkObserver(buffers, observer, creator));
            }
        };
    }

    public static class UnitTest {
        private Observer<List<String>> observer;
        private TestScheduler scheduler;

        @Before
        public void before() {
            this.observer = (Observer)Mockito.mock(Observer.class);
            this.scheduler = new TestScheduler();
        }

        @Test
        public void testComplete() {
            Observable<String> source = Observable.create(new Observable.OnSubscribeFunc<String>(){

                @Override
                public Subscription onSubscribe(Observer<? super String> observer) {
                    observer.onCompleted();
                    return Subscriptions.empty();
                }
            });
            Observable<List<String>> buffered = Observable.create(OperationBuffer.buffer(source, 3, 3));
            buffered.subscribe(this.observer);
            ((Observer)Mockito.verify(this.observer, (VerificationMode)Mockito.never())).onNext(Mockito.anyListOf(String.class));
            ((Observer)Mockito.verify(this.observer, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify(this.observer, (VerificationMode)Mockito.times((int)1))).onCompleted();
        }

        @Test
        public void testSkipAndCountOverlappingBuffers() {
            Observable<String> source = Observable.create(new Observable.OnSubscribeFunc<String>(){

                @Override
                public Subscription onSubscribe(Observer<? super String> observer) {
                    observer.onNext("one");
                    observer.onNext("two");
                    observer.onNext("three");
                    observer.onNext("four");
                    observer.onNext("five");
                    return Subscriptions.empty();
                }
            });
            Observable<List<String>> buffered = Observable.create(OperationBuffer.buffer(source, 3, 1));
            buffered.subscribe(this.observer);
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.observer});
            ((Observer)inOrder.verify(this.observer, Mockito.times((int)1))).onNext(this.list("one", "two", "three"));
            ((Observer)inOrder.verify(this.observer, Mockito.times((int)1))).onNext(this.list("two", "three", "four"));
            ((Observer)inOrder.verify(this.observer, Mockito.times((int)1))).onNext(this.list("three", "four", "five"));
            ((Observer)inOrder.verify(this.observer, Mockito.never())).onNext(Mockito.anyListOf(String.class));
            ((Observer)inOrder.verify(this.observer, Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)inOrder.verify(this.observer, Mockito.never())).onCompleted();
        }

        @Test
        public void testSkipAndCountGaplessBuffers() {
            Observable<String> source = Observable.create(new Observable.OnSubscribeFunc<String>(){

                @Override
                public Subscription onSubscribe(Observer<? super String> observer) {
                    observer.onNext("one");
                    observer.onNext("two");
                    observer.onNext("three");
                    observer.onNext("four");
                    observer.onNext("five");
                    observer.onCompleted();
                    return Subscriptions.empty();
                }
            });
            Observable<List<String>> buffered = Observable.create(OperationBuffer.buffer(source, 3, 3));
            buffered.subscribe(this.observer);
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.observer});
            ((Observer)inOrder.verify(this.observer, Mockito.times((int)1))).onNext(this.list("one", "two", "three"));
            ((Observer)inOrder.verify(this.observer, Mockito.times((int)1))).onNext(this.list("four", "five"));
            ((Observer)inOrder.verify(this.observer, Mockito.never())).onNext(Mockito.anyListOf(String.class));
            ((Observer)inOrder.verify(this.observer, Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)inOrder.verify(this.observer, Mockito.times((int)1))).onCompleted();
        }

        @Test
        public void testSkipAndCountBuffersWithGaps() {
            Observable<String> source = Observable.create(new Observable.OnSubscribeFunc<String>(){

                @Override
                public Subscription onSubscribe(Observer<? super String> observer) {
                    observer.onNext("one");
                    observer.onNext("two");
                    observer.onNext("three");
                    observer.onNext("four");
                    observer.onNext("five");
                    observer.onCompleted();
                    return Subscriptions.empty();
                }
            });
            Observable<List<String>> buffered = Observable.create(OperationBuffer.buffer(source, 2, 3));
            buffered.subscribe(this.observer);
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.observer});
            ((Observer)inOrder.verify(this.observer, Mockito.times((int)1))).onNext(this.list("one", "two"));
            ((Observer)inOrder.verify(this.observer, Mockito.times((int)1))).onNext(this.list("four", "five"));
            ((Observer)inOrder.verify(this.observer, Mockito.never())).onNext(Mockito.anyListOf(String.class));
            ((Observer)inOrder.verify(this.observer, Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)inOrder.verify(this.observer, Mockito.times((int)1))).onCompleted();
        }

        @Test
        public void testTimedAndCount() {
            Observable<String> source = Observable.create(new Observable.OnSubscribeFunc<String>(){

                @Override
                public Subscription onSubscribe(Observer<? super String> observer) {
                    UnitTest.this.push(observer, "one", 10);
                    UnitTest.this.push(observer, "two", 90);
                    UnitTest.this.push(observer, "three", 110);
                    UnitTest.this.push(observer, "four", 190);
                    UnitTest.this.push(observer, "five", 210);
                    UnitTest.this.complete(observer, 250);
                    return Subscriptions.empty();
                }
            });
            Observable<List<String>> buffered = Observable.create(OperationBuffer.buffer(source, 100L, TimeUnit.MILLISECONDS, 2, (Scheduler)this.scheduler));
            buffered.subscribe(this.observer);
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.observer});
            this.scheduler.advanceTimeTo(100L, TimeUnit.MILLISECONDS);
            ((Observer)inOrder.verify(this.observer, Mockito.times((int)1))).onNext(this.list("one", "two"));
            this.scheduler.advanceTimeTo(200L, TimeUnit.MILLISECONDS);
            ((Observer)inOrder.verify(this.observer, Mockito.times((int)1))).onNext(this.list("three", "four"));
            this.scheduler.advanceTimeTo(300L, TimeUnit.MILLISECONDS);
            ((Observer)inOrder.verify(this.observer, Mockito.times((int)1))).onNext(this.list("five"));
            ((Observer)inOrder.verify(this.observer, Mockito.never())).onNext(Mockito.anyListOf(String.class));
            ((Observer)inOrder.verify(this.observer, Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)inOrder.verify(this.observer, Mockito.times((int)1))).onCompleted();
        }

        @Test
        public void testTimed() {
            Observable<String> source = Observable.create(new Observable.OnSubscribeFunc<String>(){

                @Override
                public Subscription onSubscribe(Observer<? super String> observer) {
                    UnitTest.this.push(observer, "one", 98);
                    UnitTest.this.push(observer, "two", 99);
                    UnitTest.this.push(observer, "three", 100);
                    UnitTest.this.push(observer, "four", 101);
                    UnitTest.this.push(observer, "five", 102);
                    UnitTest.this.complete(observer, 150);
                    return Subscriptions.empty();
                }
            });
            Observable<List<String>> buffered = Observable.create(OperationBuffer.buffer(source, 100L, TimeUnit.MILLISECONDS, this.scheduler));
            buffered.subscribe(this.observer);
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.observer});
            this.scheduler.advanceTimeTo(101L, TimeUnit.MILLISECONDS);
            ((Observer)inOrder.verify(this.observer, Mockito.times((int)1))).onNext(this.list("one", "two", "three"));
            this.scheduler.advanceTimeTo(201L, TimeUnit.MILLISECONDS);
            ((Observer)inOrder.verify(this.observer, Mockito.times((int)1))).onNext(this.list("four", "five"));
            ((Observer)inOrder.verify(this.observer, Mockito.never())).onNext(Mockito.anyListOf(String.class));
            ((Observer)inOrder.verify(this.observer, Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)inOrder.verify(this.observer, Mockito.times((int)1))).onCompleted();
        }

        @Test
        public void testObservableBasedOpenerAndCloser() {
            Observable<String> source = Observable.create(new Observable.OnSubscribeFunc<String>(){

                @Override
                public Subscription onSubscribe(Observer<? super String> observer) {
                    UnitTest.this.push(observer, "one", 10);
                    UnitTest.this.push(observer, "two", 60);
                    UnitTest.this.push(observer, "three", 110);
                    UnitTest.this.push(observer, "four", 160);
                    UnitTest.this.push(observer, "five", 210);
                    UnitTest.this.complete(observer, 500);
                    return Subscriptions.empty();
                }
            });
            Observable<Opening> openings = Observable.create(new Observable.OnSubscribeFunc<Opening>(){

                @Override
                public Subscription onSubscribe(Observer<? super Opening> observer) {
                    UnitTest.this.push(observer, Openings.create(), 50);
                    UnitTest.this.push(observer, Openings.create(), 200);
                    UnitTest.this.complete(observer, 250);
                    return Subscriptions.empty();
                }
            });
            Func1<Opening, Observable<Closing>> closer = new Func1<Opening, Observable<Closing>>(){

                @Override
                public Observable<Closing> call(Opening opening) {
                    return Observable.create(new Observable.OnSubscribeFunc<Closing>(){

                        @Override
                        public Subscription onSubscribe(Observer<? super Closing> observer) {
                            UnitTest.this.push(observer, Closings.create(), 100);
                            UnitTest.this.complete(observer, 101);
                            return Subscriptions.empty();
                        }
                    });
                }
            };
            Observable<List<String>> buffered = Observable.create(OperationBuffer.buffer(source, openings, (Func1<Opening, ? extends Observable<? extends Closing>>)closer));
            buffered.subscribe(this.observer);
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.observer});
            this.scheduler.advanceTimeTo(500L, TimeUnit.MILLISECONDS);
            ((Observer)inOrder.verify(this.observer, Mockito.times((int)1))).onNext(this.list("two", "three"));
            ((Observer)inOrder.verify(this.observer, Mockito.times((int)1))).onNext(this.list("five"));
            ((Observer)inOrder.verify(this.observer, Mockito.never())).onNext(Mockito.anyListOf(String.class));
            ((Observer)inOrder.verify(this.observer, Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)inOrder.verify(this.observer, Mockito.times((int)1))).onCompleted();
        }

        @Test
        public void testObservableBasedCloser() {
            Observable<String> source = Observable.create(new Observable.OnSubscribeFunc<String>(){

                @Override
                public Subscription onSubscribe(Observer<? super String> observer) {
                    UnitTest.this.push(observer, "one", 10);
                    UnitTest.this.push(observer, "two", 60);
                    UnitTest.this.push(observer, "three", 110);
                    UnitTest.this.push(observer, "four", 160);
                    UnitTest.this.push(observer, "five", 210);
                    UnitTest.this.complete(observer, 250);
                    return Subscriptions.empty();
                }
            });
            Func0<Observable<Closing>> closer = new Func0<Observable<Closing>>(){

                @Override
                public Observable<Closing> call() {
                    return Observable.create(new Observable.OnSubscribeFunc<Closing>(){

                        @Override
                        public Subscription onSubscribe(Observer<? super Closing> observer) {
                            UnitTest.this.push(observer, Closings.create(), 100);
                            UnitTest.this.complete(observer, 101);
                            return Subscriptions.empty();
                        }
                    });
                }
            };
            Observable<List<String>> buffered = Observable.create(OperationBuffer.buffer(source, (Func0<? extends Observable<? extends Closing>>)closer));
            buffered.subscribe(this.observer);
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.observer});
            this.scheduler.advanceTimeTo(500L, TimeUnit.MILLISECONDS);
            ((Observer)inOrder.verify(this.observer, Mockito.times((int)1))).onNext(this.list("one", "two"));
            ((Observer)inOrder.verify(this.observer, Mockito.times((int)1))).onNext(this.list("three", "four"));
            ((Observer)inOrder.verify(this.observer, Mockito.times((int)1))).onNext(this.list("five"));
            ((Observer)inOrder.verify(this.observer, Mockito.never())).onNext(Mockito.anyListOf(String.class));
            ((Observer)inOrder.verify(this.observer, Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)inOrder.verify(this.observer, Mockito.times((int)1))).onCompleted();
        }

        private List<String> list(String ... args) {
            ArrayList<String> list = new ArrayList<String>();
            for (String arg : args) {
                list.add(arg);
            }
            return list;
        }

        private <T> void push(final Observer<T> observer, final T value, int delay) {
            this.scheduler.schedule(new Action0(){

                @Override
                public void call() {
                    observer.onNext(value);
                }
            }, delay, TimeUnit.MILLISECONDS);
        }

        private void complete(final Observer<?> observer, int delay) {
            this.scheduler.schedule(new Action0(){

                @Override
                public void call() {
                    observer.onCompleted();
                }
            }, delay, TimeUnit.MILLISECONDS);
        }
    }

    protected static class Buffer<T>
    extends ChunkedOperation.Chunk<T, List<T>> {
        protected Buffer() {
        }

        @Override
        public List<T> getContents() {
            return this.contents;
        }
    }
}

