/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import rx.Observable;
import rx.Observer;
import rx.operators.OperationMap;
import rx.util.functions.Func1;

public class OperationCast {
    public static <T, R> Observable.OnSubscribeFunc<R> cast(Observable<? extends T> source, final Class<R> klass) {
        return OperationMap.map(source, new Func1<T, R>(){

            @Override
            public R call(T t) {
                return klass.cast(t);
            }
        });
    }

    public static class UnitTest {
        @Test
        public void testCast() {
            Observable<Integer> source = Observable.from(1, 2);
            Observable<Integer> observable = Observable.create(OperationCast.cast(source, Integer.class));
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            observable.subscribe(aObserver);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext(1);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext(1);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onError((Throwable)Matchers.any(Throwable.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onCompleted();
        }

        @Test
        public void testCastWithWrongType() {
            Observable<Integer> source = Observable.from(1, 2);
            Observable<Boolean> observable = Observable.create(OperationCast.cast(source, Boolean.class));
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            observable.subscribe(aObserver);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onError((Throwable)Matchers.any(ClassCastException.class));
        }
    }
}

