/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.operators.SafeObservableSubscription;

public class OperationDefaultIfEmpty {
    public static <T> Observable.OnSubscribeFunc<T> defaultIfEmpty(Observable<? extends T> source, T defaultValue) {
        return new DefaultIfEmpty(source, defaultValue);
    }

    public static class UnitTest {
        @Test
        public void testDefaultIfEmpty() {
            Observable<Integer> source = Observable.from(1, Integer.valueOf(2), 3);
            Observable<Integer> observable = Observable.create(OperationDefaultIfEmpty.defaultIfEmpty(source, 10));
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            observable.subscribe(aObserver);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onNext(10);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext(1);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext(2);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext(3);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onError((Throwable)Matchers.any(Throwable.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onCompleted();
        }

        @Test
        public void testDefaultIfEmptyWithEmpty() {
            Observable source = Observable.empty();
            Observable<Integer> observable = Observable.create(OperationDefaultIfEmpty.defaultIfEmpty(source, 10));
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            observable.subscribe(aObserver);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext(10);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onError((Throwable)Matchers.any(Throwable.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onCompleted();
        }
    }

    private static class DefaultIfEmpty<T>
    implements Observable.OnSubscribeFunc<T> {
        private final Observable<? extends T> source;
        private final T defaultValue;

        private DefaultIfEmpty(Observable<? extends T> source, T defaultValue) {
            this.source = source;
            this.defaultValue = defaultValue;
        }

        @Override
        public Subscription onSubscribe(final Observer<? super T> observer) {
            final SafeObservableSubscription subscription = new SafeObservableSubscription();
            return subscription.wrap(this.source.subscribe(new Observer<T>(){
                private volatile boolean hasEmitted = false;

                @Override
                public void onNext(T value) {
                    try {
                        this.hasEmitted = true;
                        observer.onNext(value);
                    }
                    catch (Throwable ex) {
                        observer.onError(ex);
                        subscription.unsubscribe();
                    }
                }

                @Override
                public void onError(Throwable ex) {
                    observer.onError(ex);
                }

                @Override
                public void onCompleted() {
                    if (this.hasEmitted) {
                        observer.onCompleted();
                    } else {
                        observer.onNext(DefaultIfEmpty.this.defaultValue);
                        observer.onCompleted();
                    }
                }
            }));
        }
    }
}

