/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.subscriptions.Subscriptions;
import rx.util.functions.Action0;
import rx.util.functions.Func1;
import rx.util.functions.Functions;

public final class OperationDistinct {
    public static <T, U> Observable.OnSubscribeFunc<T> distinct(Observable<? extends T> source, Func1<? super T, ? extends U> keySelector) {
        return new Distinct(source, keySelector);
    }

    public static <T> Observable.OnSubscribeFunc<T> distinct(Observable<? extends T> source, Comparator<T> equalityComparator) {
        return new DistinctWithComparator(source, Functions.identity(), equalityComparator);
    }

    public static <T, U> Observable.OnSubscribeFunc<T> distinct(Observable<? extends T> source, Func1<? super T, ? extends U> keySelector, Comparator<U> equalityComparator) {
        return new DistinctWithComparator(source, keySelector, equalityComparator);
    }

    public static <T> Observable.OnSubscribeFunc<T> distinct(Observable<? extends T> source) {
        return new Distinct(source, Functions.identity());
    }

    public static class UnitTest {
        @Mock
        Observer<? super String> w;
        @Mock
        Observer<? super String> w2;
        final Func1<String, String> TO_UPPER_WITH_EXCEPTION = new Func1<String, String>(){

            @Override
            public String call(String s) {
                if (s.equals("x")) {
                    return "XX";
                }
                return s.toUpperCase();
            }
        };
        final Comparator<String> COMPARE_LENGTH = new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                return s1.length() - s2.length();
            }
        };

        @Before
        public void before() {
            MockitoAnnotations.initMocks((Object)this);
        }

        @Test
        public void testDistinctOfNone() {
            Observable src = Observable.empty();
            Observable.create(OperationDistinct.distinct(src)).subscribe(this.w);
            ((Observer)Mockito.verify(this.w, (VerificationMode)Mockito.never())).onNext(Mockito.anyString());
            ((Observer)Mockito.verify(this.w, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify(this.w, (VerificationMode)Mockito.times((int)1))).onCompleted();
        }

        @Test
        public void testDistinctOfNoneWithKeySelector() {
            Observable src = Observable.empty();
            Observable.create(OperationDistinct.distinct(src, this.TO_UPPER_WITH_EXCEPTION)).subscribe(this.w);
            ((Observer)Mockito.verify(this.w, (VerificationMode)Mockito.never())).onNext(Mockito.anyString());
            ((Observer)Mockito.verify(this.w, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify(this.w, (VerificationMode)Mockito.times((int)1))).onCompleted();
        }

        @Test
        public void testDistinctOfNormalSource() {
            Observable<String> src = Observable.from("a", "b", "c", "c", "c", "b", "b", "a", "e");
            Observable.create(OperationDistinct.distinct(src)).subscribe(this.w);
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.w});
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onNext("a");
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onNext("b");
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onNext("c");
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onNext("e");
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onCompleted();
            ((Observer)inOrder.verify(this.w, Mockito.never())).onNext(Mockito.anyString());
            ((Observer)Mockito.verify(this.w, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
        }

        @Test
        public void testDistinctOfNormalSourceWithKeySelector() {
            Observable<String> src = Observable.from("a", "B", "c", "C", "c", "B", "b", "a", "E");
            Observable.create(OperationDistinct.distinct(src, this.TO_UPPER_WITH_EXCEPTION)).subscribe(this.w);
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.w});
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onNext("a");
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onNext("B");
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onNext("c");
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onNext("E");
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onCompleted();
            ((Observer)inOrder.verify(this.w, Mockito.never())).onNext(Mockito.anyString());
            ((Observer)Mockito.verify(this.w, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
        }

        @Test
        public void testDistinctOfNormalSourceWithComparator() {
            Observable<String> src = Observable.from("1", "12", "123", "aaa", "321", "12", "21", "1", "12345");
            Observable.create(OperationDistinct.distinct(src, this.COMPARE_LENGTH)).subscribe(this.w);
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.w});
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onNext("1");
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onNext("12");
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onNext("123");
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onNext("12345");
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onCompleted();
            ((Observer)inOrder.verify(this.w, Mockito.never())).onNext(Mockito.anyString());
            ((Observer)Mockito.verify(this.w, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
        }

        @Test
        public void testDistinctOfNormalSourceWithKeySelectorAndComparator() {
            Observable<String> src = Observable.from("a", "x", "ab", "abc", "cba", "de", "x", "a", "abcd");
            Observable.create(OperationDistinct.distinct(src, this.TO_UPPER_WITH_EXCEPTION, this.COMPARE_LENGTH)).subscribe(this.w);
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.w});
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onNext("a");
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onNext("x");
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onNext("abc");
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onNext("abcd");
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onCompleted();
            ((Observer)inOrder.verify(this.w, Mockito.never())).onNext(Mockito.anyString());
            ((Observer)Mockito.verify(this.w, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
        }

        @Test
        public void testDistinctOfNormalSourceWithKeySelectorAndComparatorAndTwoSubscriptions() {
            Observable<String> src = Observable.from("a", "x", "ab", "abc", "cba", "de", "x", "a", "abcd");
            Observable.create(OperationDistinct.distinct(src, this.TO_UPPER_WITH_EXCEPTION, this.COMPARE_LENGTH)).subscribe(this.w);
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.w});
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onNext("a");
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onNext("x");
            Observable.create(OperationDistinct.distinct(src, this.TO_UPPER_WITH_EXCEPTION, this.COMPARE_LENGTH)).subscribe(this.w2);
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onNext("abc");
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onNext("abcd");
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onCompleted();
            ((Observer)inOrder.verify(this.w, Mockito.never())).onNext(Mockito.anyString());
            ((Observer)Mockito.verify(this.w, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            InOrder inOrder2 = Mockito.inOrder((Object[])new Object[]{this.w2});
            ((Observer)inOrder2.verify(this.w2, Mockito.times((int)1))).onNext("a");
            ((Observer)inOrder2.verify(this.w2, Mockito.times((int)1))).onNext("x");
            ((Observer)inOrder2.verify(this.w2, Mockito.times((int)1))).onNext("abc");
            ((Observer)inOrder2.verify(this.w2, Mockito.times((int)1))).onNext("abcd");
            ((Observer)inOrder2.verify(this.w2, Mockito.times((int)1))).onCompleted();
            ((Observer)inOrder2.verify(this.w2, Mockito.never())).onNext(Mockito.anyString());
            ((Observer)Mockito.verify(this.w2, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
        }

        @Test
        public void testDistinctOfSourceWithNulls() {
            Observable<Object> src = Observable.from(null, "a", "a", null, null, "b", null);
            Observable.create(OperationDistinct.distinct(src)).subscribe(this.w);
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.w});
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onNext(null);
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onNext("a");
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onNext("b");
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onCompleted();
            ((Observer)inOrder.verify(this.w, Mockito.never())).onNext(Mockito.anyString());
            ((Observer)Mockito.verify(this.w, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
        }

        @Test
        public void testDistinctOfSourceWithExceptionsFromKeySelector() {
            Observable<String> src = Observable.from("a", "b", null, "c");
            Observable.create(OperationDistinct.distinct(src, this.TO_UPPER_WITH_EXCEPTION)).subscribe(this.w);
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.w});
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onNext("a");
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onNext("b");
            ((Observer)inOrder.verify(this.w, Mockito.times((int)1))).onError((Throwable)Mockito.any(NullPointerException.class));
            ((Observer)inOrder.verify(this.w, Mockito.never())).onNext(Mockito.anyString());
            ((Observer)inOrder.verify(this.w, Mockito.never())).onCompleted();
        }
    }

    private static class DistinctWithComparator<T, U>
    implements Observable.OnSubscribeFunc<T> {
        private final Observable<? extends T> source;
        private final Func1<? super T, ? extends U> keySelector;
        private final Comparator<U> equalityComparator;

        private DistinctWithComparator(Observable<? extends T> source, Func1<? super T, ? extends U> keySelector, Comparator<U> equalityComparator) {
            this.source = source;
            this.keySelector = keySelector;
            this.equalityComparator = equalityComparator;
        }

        @Override
        public Subscription onSubscribe(final Observer<? super T> observer) {
            final Subscription sourceSub = this.source.subscribe(new Observer<T>(){
                private final List<U> emittedKeys = new ArrayList();

                @Override
                public void onCompleted() {
                    observer.onCompleted();
                }

                @Override
                public void onError(Throwable e) {
                    observer.onError(e);
                }

                @Override
                public void onNext(T next) {
                    Object nextKey = DistinctWithComparator.this.keySelector.call(next);
                    if (!this.alreadyEmitted(nextKey)) {
                        this.emittedKeys.add(nextKey);
                        observer.onNext(next);
                    }
                }

                private boolean alreadyEmitted(U newKey) {
                    for (Object key : this.emittedKeys) {
                        if (DistinctWithComparator.this.equalityComparator.compare(key, newKey) != 0) continue;
                        return true;
                    }
                    return false;
                }
            });
            return Subscriptions.create(new Action0(){

                @Override
                public void call() {
                    sourceSub.unsubscribe();
                }
            });
        }
    }

    private static class Distinct<T, U>
    implements Observable.OnSubscribeFunc<T> {
        private final Observable<? extends T> source;
        private final Func1<? super T, ? extends U> keySelector;

        private Distinct(Observable<? extends T> source, Func1<? super T, ? extends U> keySelector) {
            this.source = source;
            this.keySelector = keySelector;
        }

        @Override
        public Subscription onSubscribe(final Observer<? super T> observer) {
            final Subscription sourceSub = this.source.subscribe(new Observer<T>(){
                private final Set<U> emittedKeys = new HashSet();

                @Override
                public void onCompleted() {
                    observer.onCompleted();
                }

                @Override
                public void onError(Throwable e) {
                    observer.onError(e);
                }

                @Override
                public void onNext(T next) {
                    Object nextKey = Distinct.this.keySelector.call(next);
                    if (!this.emittedKeys.contains(nextKey)) {
                        this.emittedKeys.add(nextKey);
                        observer.onNext(next);
                    }
                }
            });
            return Subscriptions.create(new Action0(){

                @Override
                public void call() {
                    sourceSub.unsubscribe();
                }
            });
        }
    }
}

