/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.subscriptions.Subscriptions;
import rx.util.functions.Action0;
import rx.util.functions.Func1;
import rx.util.functions.Functions;

public final class OperationFirstOrDefault {
    public static <T> Observable.OnSubscribeFunc<T> firstOrDefault(Observable<? extends T> source, Func1<? super T, Boolean> predicate, T defaultValue) {
        return new FirstOrElse(source, predicate, defaultValue);
    }

    public static <T> Observable.OnSubscribeFunc<T> firstOrDefault(Observable<? extends T> source, T defaultValue) {
        return new FirstOrElse(source, Functions.alwaysTrue(), defaultValue);
    }

    public static class UnitTest {
        @Mock
        Observer<? super String> w;
        private static final Func1<String, Boolean> IS_D = new Func1<String, Boolean>(){

            @Override
            public Boolean call(String value) {
                return "d".equals(value);
            }
        };

        @Before
        public void before() {
            MockitoAnnotations.initMocks((Object)this);
        }

        @Test
        public void testFirstOrElseOfNone() {
            Observable src = Observable.empty();
            Observable.create(OperationFirstOrDefault.firstOrDefault(src, "default")).subscribe(this.w);
            ((Observer)Mockito.verify(this.w, (VerificationMode)Mockito.times((int)1))).onNext(Mockito.anyString());
            ((Observer)Mockito.verify(this.w, (VerificationMode)Mockito.times((int)1))).onNext("default");
            ((Observer)Mockito.verify(this.w, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify(this.w, (VerificationMode)Mockito.times((int)1))).onCompleted();
        }

        @Test
        public void testFirstOrElseOfSome() {
            Observable<String> src = Observable.from("a", "b", "c");
            Observable.create(OperationFirstOrDefault.firstOrDefault(src, "default")).subscribe(this.w);
            ((Observer)Mockito.verify(this.w, (VerificationMode)Mockito.times((int)1))).onNext(Mockito.anyString());
            ((Observer)Mockito.verify(this.w, (VerificationMode)Mockito.times((int)1))).onNext("a");
            ((Observer)Mockito.verify(this.w, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify(this.w, (VerificationMode)Mockito.times((int)1))).onCompleted();
        }

        @Test
        public void testFirstOrElseWithPredicateOfNoneMatchingThePredicate() {
            Observable<String> src = Observable.from("a", "b", "c");
            Observable.create(OperationFirstOrDefault.firstOrDefault(src, IS_D, "default")).subscribe(this.w);
            ((Observer)Mockito.verify(this.w, (VerificationMode)Mockito.times((int)1))).onNext(Mockito.anyString());
            ((Observer)Mockito.verify(this.w, (VerificationMode)Mockito.times((int)1))).onNext("default");
            ((Observer)Mockito.verify(this.w, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify(this.w, (VerificationMode)Mockito.times((int)1))).onCompleted();
        }

        @Test
        public void testFirstOrElseWithPredicateOfSome() {
            Observable<String> src = Observable.from("a", "b", "c", "d", "e", "f");
            Observable.create(OperationFirstOrDefault.firstOrDefault(src, IS_D, "default")).subscribe(this.w);
            ((Observer)Mockito.verify(this.w, (VerificationMode)Mockito.times((int)1))).onNext(Mockito.anyString());
            ((Observer)Mockito.verify(this.w, (VerificationMode)Mockito.times((int)1))).onNext("d");
            ((Observer)Mockito.verify(this.w, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify(this.w, (VerificationMode)Mockito.times((int)1))).onCompleted();
        }
    }

    private static class FirstOrElse<T>
    implements Observable.OnSubscribeFunc<T> {
        private final Observable<? extends T> source;
        private final Func1<? super T, Boolean> predicate;
        private final T defaultValue;

        private FirstOrElse(Observable<? extends T> source, Func1<? super T, Boolean> predicate, T defaultValue) {
            this.source = source;
            this.defaultValue = defaultValue;
            this.predicate = predicate;
        }

        @Override
        public Subscription onSubscribe(final Observer<? super T> observer) {
            final Subscription sourceSub = this.source.subscribe(new Observer<T>(){
                private final AtomicBoolean hasEmitted = new AtomicBoolean(false);

                @Override
                public void onCompleted() {
                    if (!this.hasEmitted.get()) {
                        observer.onNext(FirstOrElse.this.defaultValue);
                        observer.onCompleted();
                    }
                }

                @Override
                public void onError(Throwable e) {
                    observer.onError(e);
                }

                @Override
                public void onNext(T next) {
                    try {
                        if (!this.hasEmitted.get() && ((Boolean)FirstOrElse.this.predicate.call(next)).booleanValue()) {
                            this.hasEmitted.set(true);
                            observer.onNext(next);
                            observer.onCompleted();
                        }
                    }
                    catch (Throwable t) {
                        observer.onError(t);
                    }
                }
            });
            return Subscriptions.create(new Action0(){

                @Override
                public void call() {
                    sourceSub.unsubscribe();
                }
            });
        }
    }
}

