/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.util.CompositeException;

public final class OperationMergeDelayError {
    public static <T> Observable.OnSubscribeFunc<T> mergeDelayError(final Observable<? extends Observable<? extends T>> sequences) {
        return new Observable.OnSubscribeFunc<T>(){

            @Override
            public Subscription onSubscribe(Observer<? super T> observer) {
                return new MergeDelayErrorObservable(sequences).onSubscribe(observer);
            }
        };
    }

    public static <T> Observable.OnSubscribeFunc<T> mergeDelayError(final Observable<? extends T> ... sequences) {
        return OperationMergeDelayError.mergeDelayError(Observable.create(new Observable.OnSubscribeFunc<Observable<? extends T>>(){
            private volatile boolean unsubscribed = false;

            @Override
            public Subscription onSubscribe(Observer<? super Observable<? extends T>> observer) {
                for (Observable o : sequences) {
                    if (this.unsubscribed) break;
                    observer.onNext(o);
                }
                if (!this.unsubscribed) {
                    observer.onCompleted();
                }
                return new Subscription(){

                    @Override
                    public void unsubscribe() {
                        unsubscribed = true;
                    }
                };
            }
        }));
    }

    public static <T> Observable.OnSubscribeFunc<T> mergeDelayError(final List<? extends Observable<? extends T>> sequences) {
        return OperationMergeDelayError.mergeDelayError(Observable.create(new Observable.OnSubscribeFunc<Observable<? extends T>>(){
            private volatile boolean unsubscribed = false;

            @Override
            public Subscription onSubscribe(Observer<? super Observable<? extends T>> observer) {
                for (Observable o : sequences) {
                    if (this.unsubscribed) break;
                    observer.onNext(o);
                }
                if (!this.unsubscribed) {
                    observer.onCompleted();
                }
                return new Subscription(){

                    @Override
                    public void unsubscribe() {
                        unsubscribed = true;
                    }
                };
            }
        }));
    }

    public static class UnitTest {
        @Mock
        Observer<String> stringObserver;

        @Before
        public void before() {
            MockitoAnnotations.initMocks((Object)this);
        }

        @Test
        public void testErrorDelayed1() {
            Observable<String> o1 = Observable.create(new TestErrorObservable("four", null, "six"));
            Observable<String> o2 = Observable.create(new TestErrorObservable("one", "two", "three"));
            Observable<String> m = Observable.create(OperationMergeDelayError.mergeDelayError(o1, o2));
            m.subscribe(this.stringObserver);
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)1))).onError((Throwable)Mockito.any(NullPointerException.class));
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.never())).onCompleted();
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)1))).onNext("one");
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)1))).onNext("two");
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)1))).onNext("three");
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)1))).onNext("four");
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)0))).onNext("five");
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)0))).onNext("six");
        }

        @Test
        public void testErrorDelayed2() {
            Observable<String> o1 = Observable.create(new TestErrorObservable("one", "two", "three"));
            Observable<String> o2 = Observable.create(new TestErrorObservable("four", null, "six"));
            Observable<String> o3 = Observable.create(new TestErrorObservable("seven", "eight", null));
            Observable<String> o4 = Observable.create(new TestErrorObservable("nine"));
            Observable<String> m = Observable.create(OperationMergeDelayError.mergeDelayError(o1, o2, o3, o4));
            m.subscribe(this.stringObserver);
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)1))).onError((Throwable)Mockito.any(NullPointerException.class));
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.never())).onCompleted();
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)1))).onNext("one");
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)1))).onNext("two");
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)1))).onNext("three");
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)1))).onNext("four");
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)0))).onNext("five");
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)0))).onNext("six");
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)1))).onNext("seven");
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)1))).onNext("eight");
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)1))).onNext("nine");
        }

        @Test
        public void testErrorDelayed3() {
            Observable<String> o1 = Observable.create(new TestErrorObservable("one", "two", "three"));
            Observable<String> o2 = Observable.create(new TestErrorObservable("four", "five", "six"));
            Observable<String> o3 = Observable.create(new TestErrorObservable("seven", "eight", null));
            Observable<String> o4 = Observable.create(new TestErrorObservable("nine"));
            Observable<String> m = Observable.create(OperationMergeDelayError.mergeDelayError(o1, o2, o3, o4));
            m.subscribe(this.stringObserver);
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)1))).onError((Throwable)Mockito.any(NullPointerException.class));
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.never())).onCompleted();
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)1))).onNext("one");
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)1))).onNext("two");
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)1))).onNext("three");
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)1))).onNext("four");
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)1))).onNext("five");
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)1))).onNext("six");
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)1))).onNext("seven");
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)1))).onNext("eight");
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)1))).onNext("nine");
        }

        @Test
        public void testErrorDelayed4() {
            Observable<String> o1 = Observable.create(new TestErrorObservable("one", "two", "three"));
            Observable<String> o2 = Observable.create(new TestErrorObservable("four", "five", "six"));
            Observable<String> o3 = Observable.create(new TestErrorObservable("seven", "eight"));
            Observable<String> o4 = Observable.create(new TestErrorObservable("nine", null));
            Observable<String> m = Observable.create(OperationMergeDelayError.mergeDelayError(o1, o2, o3, o4));
            m.subscribe(this.stringObserver);
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)1))).onError((Throwable)Mockito.any(NullPointerException.class));
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.never())).onCompleted();
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)1))).onNext("one");
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)1))).onNext("two");
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)1))).onNext("three");
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)1))).onNext("four");
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)1))).onNext("five");
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)1))).onNext("six");
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)1))).onNext("seven");
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)1))).onNext("eight");
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)1))).onNext("nine");
        }

        @Test
        public void testErrorDelayed4WithThreading() {
            TestAsyncErrorObservable o1 = new TestAsyncErrorObservable("one", "two", "three");
            TestAsyncErrorObservable o2 = new TestAsyncErrorObservable("four", "five", "six");
            TestAsyncErrorObservable o3 = new TestAsyncErrorObservable("seven", "eight");
            TestAsyncErrorObservable o4 = new TestAsyncErrorObservable("nine", null);
            Observable<String> m = Observable.create(OperationMergeDelayError.mergeDelayError(Observable.create(o1), Observable.create(o2), Observable.create(o3), Observable.create(o4)));
            m.subscribe(this.stringObserver);
            try {
                o1.t.join();
                o2.t.join();
                o3.t.join();
                o4.t.join();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)1))).onError((Throwable)Mockito.any(NullPointerException.class));
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.never())).onCompleted();
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)1))).onNext("one");
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)1))).onNext("two");
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)1))).onNext("three");
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)1))).onNext("four");
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)1))).onNext("five");
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)1))).onNext("six");
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)1))).onNext("seven");
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)1))).onNext("eight");
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)1))).onNext("nine");
        }

        @Test
        public void testCompositeErrorDelayed1() {
            Observable<String> o1 = Observable.create(new TestErrorObservable("four", null, "six"));
            Observable<String> o2 = Observable.create(new TestErrorObservable("one", "two", null));
            Observable<String> m = Observable.create(OperationMergeDelayError.mergeDelayError(o1, o2));
            m.subscribe(this.stringObserver);
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)1))).onError((Throwable)Mockito.any(CompositeException.class));
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.never())).onCompleted();
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)1))).onNext("one");
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)1))).onNext("two");
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)0))).onNext("three");
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)1))).onNext("four");
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)0))).onNext("five");
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)0))).onNext("six");
        }

        @Test
        public void testCompositeErrorDelayed2() {
            Observable<String> o1 = Observable.create(new TestErrorObservable("four", null, "six"));
            Observable<String> o2 = Observable.create(new TestErrorObservable("one", "two", null));
            Observable<String> m = Observable.create(OperationMergeDelayError.mergeDelayError(o1, o2));
            CaptureObserver w = new CaptureObserver();
            m.subscribe(w);
            Assert.assertNotNull((Object)w.e);
            if (w.e instanceof CompositeException) {
                Assert.assertEquals((long)2L, (long)((CompositeException)w.e).getExceptions().size());
                w.e.printStackTrace();
            } else {
                Assert.fail((String)"Expecting CompositeException");
            }
        }

        @Test
        public void testMergeObservableOfObservables() {
            final Observable<String> o1 = Observable.create(new TestSynchronousObservable());
            final Observable<String> o2 = Observable.create(new TestSynchronousObservable());
            Observable<Observable<String>> observableOfObservables = Observable.create(new Observable.OnSubscribeFunc<Observable<String>>(){

                @Override
                public Subscription onSubscribe(Observer<? super Observable<String>> observer) {
                    observer.onNext(o1);
                    observer.onNext(o2);
                    observer.onCompleted();
                    return new Subscription(){

                        @Override
                        public void unsubscribe() {
                        }
                    };
                }
            });
            Observable<String> m = Observable.create(OperationMergeDelayError.mergeDelayError(observableOfObservables));
            m.subscribe(this.stringObserver);
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)1))).onCompleted();
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)2))).onNext("hello");
        }

        @Test
        public void testMergeArray() {
            Observable<String> o1 = Observable.create(new TestSynchronousObservable());
            Observable<String> o2 = Observable.create(new TestSynchronousObservable());
            Observable<String> m = Observable.create(OperationMergeDelayError.mergeDelayError(o1, o2));
            m.subscribe(this.stringObserver);
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)2))).onNext("hello");
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)1))).onCompleted();
        }

        @Test
        public void testMergeList() {
            Observable<String> o1 = Observable.create(new TestSynchronousObservable());
            Observable<String> o2 = Observable.create(new TestSynchronousObservable());
            ArrayList<Observable<String>> listOfObservables = new ArrayList<Observable<String>>();
            listOfObservables.add(o1);
            listOfObservables.add(o2);
            Observable<String> m = Observable.create(OperationMergeDelayError.mergeDelayError(listOfObservables));
            m.subscribe(this.stringObserver);
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)1))).onCompleted();
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)2))).onNext("hello");
        }

        @Test
        public void testUnSubscribe() {
            TestObservable tA = new TestObservable();
            TestObservable tB = new TestObservable();
            Observable<String> m = Observable.create(OperationMergeDelayError.mergeDelayError(Observable.create(tA), Observable.create(tB)));
            Subscription s = m.subscribe(this.stringObserver);
            tA.sendOnNext("Aone");
            tB.sendOnNext("Bone");
            s.unsubscribe();
            tA.sendOnNext("Atwo");
            tB.sendOnNext("Btwo");
            tA.sendOnCompleted();
            tB.sendOnCompleted();
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)1))).onNext("Aone");
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)1))).onNext("Bone");
            Assert.assertTrue((boolean)tA.unsubscribed);
            Assert.assertTrue((boolean)tB.unsubscribed);
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.never())).onNext("Atwo");
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.never())).onNext("Btwo");
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.never())).onCompleted();
        }

        @Test
        public void testMergeArrayWithThreading() {
            TestASynchronousObservable o1 = new TestASynchronousObservable();
            TestASynchronousObservable o2 = new TestASynchronousObservable();
            Observable<String> m = Observable.create(OperationMergeDelayError.mergeDelayError(Observable.create(o1), Observable.create(o2)));
            m.subscribe(this.stringObserver);
            try {
                o1.t.join();
                o2.t.join();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)2))).onNext("hello");
            ((Observer)Mockito.verify(this.stringObserver, (VerificationMode)Mockito.times((int)1))).onCompleted();
        }

        private static class CaptureObserver
        implements Observer<String> {
            volatile Throwable e;

            private CaptureObserver() {
            }

            @Override
            public void onCompleted() {
            }

            @Override
            public void onError(Throwable e) {
                this.e = e;
            }

            @Override
            public void onNext(String args) {
            }
        }

        private static class TestAsyncErrorObservable
        implements Observable.OnSubscribeFunc<String> {
            String[] valuesToReturn;
            Thread t;

            TestAsyncErrorObservable(String ... values) {
                this.valuesToReturn = values;
            }

            @Override
            public Subscription onSubscribe(final Observer<? super String> observer) {
                this.t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        for (String s : TestAsyncErrorObservable.this.valuesToReturn) {
                            if (s == null) {
                                System.out.println("throwing exception");
                                try {
                                    Thread.sleep(100L);
                                }
                                catch (Throwable e) {
                                    // empty catch block
                                }
                                observer.onError(new NullPointerException());
                                return;
                            }
                            observer.onNext(s);
                        }
                        System.out.println("subscription complete");
                        observer.onCompleted();
                    }
                });
                this.t.start();
                return new Subscription(){

                    @Override
                    public void unsubscribe() {
                    }
                };
            }
        }

        private static class TestErrorObservable
        implements Observable.OnSubscribeFunc<String> {
            String[] valuesToReturn;

            TestErrorObservable(String ... values) {
                this.valuesToReturn = values;
            }

            @Override
            public Subscription onSubscribe(Observer<? super String> observer) {
                boolean errorThrown = false;
                for (String s : this.valuesToReturn) {
                    if (s == null) {
                        System.out.println("throwing exception");
                        observer.onError(new NullPointerException());
                        errorThrown = true;
                        continue;
                    }
                    observer.onNext(s);
                }
                if (!errorThrown) {
                    observer.onCompleted();
                }
                return new Subscription(){

                    @Override
                    public void unsubscribe() {
                    }
                };
            }
        }

        private static class TestObservable
        implements Observable.OnSubscribeFunc<String> {
            Observer<? super String> observer = null;
            volatile boolean unsubscribed = false;
            Subscription s = new Subscription(){

                @Override
                public void unsubscribe() {
                    TestObservable.this.unsubscribed = true;
                }
            };

            private TestObservable() {
            }

            public void sendOnCompleted() {
                this.observer.onCompleted();
            }

            public void sendOnNext(String value) {
                this.observer.onNext(value);
            }

            public void sendOnError(Throwable e) {
                this.observer.onError(e);
            }

            @Override
            public Subscription onSubscribe(Observer<? super String> observer) {
                this.observer = observer;
                return this.s;
            }
        }

        private static class TestASynchronousObservable
        implements Observable.OnSubscribeFunc<String> {
            Thread t;

            private TestASynchronousObservable() {
            }

            @Override
            public Subscription onSubscribe(final Observer<? super String> observer) {
                this.t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        observer.onNext("hello");
                        observer.onCompleted();
                    }
                });
                this.t.start();
                return new Subscription(){

                    @Override
                    public void unsubscribe() {
                    }
                };
            }
        }

        private static class TestSynchronousObservable
        implements Observable.OnSubscribeFunc<String> {
            private TestSynchronousObservable() {
            }

            @Override
            public Subscription onSubscribe(Observer<? super String> observer) {
                observer.onNext("hello");
                observer.onCompleted();
                return new Subscription(){

                    @Override
                    public void unsubscribe() {
                    }
                };
            }
        }
    }

    private static final class MergeDelayErrorObservable<T>
    implements Observable.OnSubscribeFunc<T> {
        private final Observable<? extends Observable<? extends T>> sequences;
        private final MergeSubscription ourSubscription = new MergeSubscription();
        private AtomicBoolean stopped = new AtomicBoolean(false);
        private volatile boolean parentCompleted = false;
        private final ConcurrentHashMap<ChildObserver, ChildObserver> childObservers = new ConcurrentHashMap();
        private final ConcurrentHashMap<ChildObserver, Subscription> childSubscriptions = new ConcurrentHashMap();
        private ConcurrentLinkedQueue<Throwable> onErrorReceived = new ConcurrentLinkedQueue();

        private MergeDelayErrorObservable(Observable<? extends Observable<? extends T>> sequences) {
            this.sequences = sequences;
        }

        @Override
        public Subscription onSubscribe(Observer<? super T> actualObserver) {
            this.sequences.subscribe(new ParentObserver(actualObserver));
            return this.ourSubscription;
        }

        private class ChildObserver
        implements Observer<T> {
            private final Observer<? super T> actualObserver;
            private volatile boolean finished = false;

            public ChildObserver(Observer<? super T> actualObserver) {
                this.actualObserver = actualObserver;
            }

            @Override
            public void onCompleted() {
                MergeDelayErrorObservable.this.childObservers.remove(this);
                if (!MergeDelayErrorObservable.this.stopped.get()) {
                    this.finishObserver();
                }
            }

            @Override
            public void onError(Throwable e) {
                if (!MergeDelayErrorObservable.this.stopped.get()) {
                    MergeDelayErrorObservable.this.onErrorReceived.add(e);
                    MergeDelayErrorObservable.this.childObservers.remove(this);
                    this.finished = true;
                    this.finishObserver();
                }
            }

            private void finishObserver() {
                if (MergeDelayErrorObservable.this.childObservers.size() == 0 && MergeDelayErrorObservable.this.parentCompleted && MergeDelayErrorObservable.this.ourSubscription.stop()) {
                    if (MergeDelayErrorObservable.this.onErrorReceived.size() == 1) {
                        this.actualObserver.onError((Throwable)MergeDelayErrorObservable.this.onErrorReceived.peek());
                    } else if (MergeDelayErrorObservable.this.onErrorReceived.size() > 1) {
                        this.actualObserver.onError(new CompositeException(MergeDelayErrorObservable.this.onErrorReceived));
                    } else {
                        this.actualObserver.onCompleted();
                    }
                }
            }

            @Override
            public void onNext(T args) {
                if (!MergeDelayErrorObservable.this.stopped.get() && !this.finished) {
                    this.actualObserver.onNext(args);
                }
            }
        }

        private class ParentObserver
        implements Observer<Observable<? extends T>> {
            private final Observer<? super T> actualObserver;

            public ParentObserver(Observer<? super T> actualObserver) {
                this.actualObserver = actualObserver;
            }

            @Override
            public void onCompleted() {
                MergeDelayErrorObservable.this.parentCompleted = true;
                if (MergeDelayErrorObservable.this.childObservers.size() == 0 && !MergeDelayErrorObservable.this.stopped.get() && MergeDelayErrorObservable.this.ourSubscription.stop()) {
                    if (MergeDelayErrorObservable.this.onErrorReceived.size() == 1) {
                        this.actualObserver.onError((Throwable)MergeDelayErrorObservable.this.onErrorReceived.peek());
                    } else if (MergeDelayErrorObservable.this.onErrorReceived.size() > 1) {
                        this.actualObserver.onError(new CompositeException(MergeDelayErrorObservable.this.onErrorReceived));
                    } else {
                        this.actualObserver.onCompleted();
                    }
                }
            }

            @Override
            public void onError(Throwable e) {
                this.actualObserver.onError(e);
            }

            @Override
            public void onNext(Observable<? extends T> childObservable) {
                if (MergeDelayErrorObservable.this.stopped.get()) {
                    return;
                }
                if (childObservable == null) {
                    throw new IllegalArgumentException("Observable<T> can not be null.");
                }
                ChildObserver _w = new ChildObserver(this.actualObserver);
                MergeDelayErrorObservable.this.childObservers.put(_w, _w);
                Subscription _subscription = childObservable.subscribe(_w);
                MergeDelayErrorObservable.this.childSubscriptions.put(_w, _subscription);
            }
        }

        private class MergeSubscription
        implements Subscription {
            private MergeSubscription() {
            }

            @Override
            public void unsubscribe() {
                this.stop();
            }

            public boolean stop() {
                boolean didSet = MergeDelayErrorObservable.this.stopped.compareAndSet(false, true);
                if (didSet) {
                    for (Subscription _s : MergeDelayErrorObservable.this.childSubscriptions.values()) {
                        _s.unsubscribe();
                    }
                    return true;
                }
                return false;
            }
        }
    }
}

