/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.util.functions.Func2;

public final class OperationScan {
    public static <T, R> Observable.OnSubscribeFunc<R> scan(Observable<? extends T> sequence, R initialValue, Func2<R, ? super T, R> accumulator) {
        return new Accumulator(sequence, initialValue, accumulator);
    }

    public static <T> Observable.OnSubscribeFunc<T> scan(Observable<? extends T> sequence, Func2<T, T, T> accumulator) {
        return new AccuWithoutInitialValue(sequence, accumulator);
    }

    public static class UnitTest {
        @Before
        public void before() {
            MockitoAnnotations.initMocks((Object)this);
        }

        @Test
        public void testScanIntegersWithInitialValue() {
            Observer observer = (Observer)Mockito.mock(Observer.class);
            Observable<Integer> observable = Observable.from(1, Integer.valueOf(2), 3);
            Observable<String> m = Observable.create(OperationScan.scan(observable, "", new Func2<String, Integer, String>(){

                @Override
                public String call(String s, Integer n) {
                    return s + n.toString();
                }
            }));
            m.subscribe(observer);
            ((Observer)Mockito.verify((Object)observer, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify((Object)observer, (VerificationMode)Mockito.times((int)1))).onNext("");
            ((Observer)Mockito.verify((Object)observer, (VerificationMode)Mockito.times((int)1))).onNext("1");
            ((Observer)Mockito.verify((Object)observer, (VerificationMode)Mockito.times((int)1))).onNext("12");
            ((Observer)Mockito.verify((Object)observer, (VerificationMode)Mockito.times((int)1))).onNext("123");
            ((Observer)Mockito.verify((Object)observer, (VerificationMode)Mockito.times((int)4))).onNext(Mockito.anyString());
            ((Observer)Mockito.verify((Object)observer, (VerificationMode)Mockito.times((int)1))).onCompleted();
            ((Observer)Mockito.verify((Object)observer, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
        }

        @Test
        public void testScanIntegersWithoutInitialValue() {
            Observer Observer2 = (Observer)Mockito.mock(Observer.class);
            Observable<Integer> observable = Observable.from(1, Integer.valueOf(2), 3);
            Observable<Integer> m = Observable.create(OperationScan.scan(observable, new Func2<Integer, Integer, Integer>(){

                @Override
                public Integer call(Integer t1, Integer t2) {
                    return t1 + t2;
                }
            }));
            m.subscribe(Observer2);
            ((Observer)Mockito.verify((Object)Observer2, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify((Object)Observer2, (VerificationMode)Mockito.never())).onNext(0);
            ((Observer)Mockito.verify((Object)Observer2, (VerificationMode)Mockito.times((int)1))).onNext(1);
            ((Observer)Mockito.verify((Object)Observer2, (VerificationMode)Mockito.times((int)1))).onNext(3);
            ((Observer)Mockito.verify((Object)Observer2, (VerificationMode)Mockito.times((int)1))).onNext(6);
            ((Observer)Mockito.verify((Object)Observer2, (VerificationMode)Mockito.times((int)3))).onNext(Mockito.anyInt());
            ((Observer)Mockito.verify((Object)Observer2, (VerificationMode)Mockito.times((int)1))).onCompleted();
            ((Observer)Mockito.verify((Object)Observer2, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
        }

        @Test
        public void testScanIntegersWithoutInitialValueAndOnlyOneValue() {
            Observer Observer2 = (Observer)Mockito.mock(Observer.class);
            Observable<Integer> observable = Observable.from(1);
            Observable<Integer> m = Observable.create(OperationScan.scan(observable, new Func2<Integer, Integer, Integer>(){

                @Override
                public Integer call(Integer t1, Integer t2) {
                    return t1 + t2;
                }
            }));
            m.subscribe(Observer2);
            ((Observer)Mockito.verify((Object)Observer2, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify((Object)Observer2, (VerificationMode)Mockito.never())).onNext(0);
            ((Observer)Mockito.verify((Object)Observer2, (VerificationMode)Mockito.times((int)1))).onNext(1);
            ((Observer)Mockito.verify((Object)Observer2, (VerificationMode)Mockito.times((int)1))).onNext(Mockito.anyInt());
            ((Observer)Mockito.verify((Object)Observer2, (VerificationMode)Mockito.times((int)1))).onCompleted();
            ((Observer)Mockito.verify((Object)Observer2, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
        }
    }

    private static class AccumulatingObserver<T, R>
    implements Observer<T> {
        private final Observer<? super R> observer;
        private final Func2<R, ? super T, R> accumulatorFunction;
        private R acc;

        private AccumulatingObserver(Observer<? super R> observer, R initialValue, Func2<R, ? super T, R> accumulator) {
            this.observer = observer;
            this.accumulatorFunction = accumulator;
            this.acc = initialValue;
        }

        @Override
        public synchronized void onNext(T value) {
            try {
                this.acc = this.accumulatorFunction.call(this.acc, value);
                this.observer.onNext(this.acc);
            }
            catch (Throwable ex) {
                this.observer.onError(ex);
            }
        }

        @Override
        public void onError(Throwable e) {
            this.observer.onError(e);
        }

        @Override
        public void onCompleted() {
            this.observer.onCompleted();
        }
    }

    private static class Accumulator<T, R>
    implements Observable.OnSubscribeFunc<R> {
        private final Observable<? extends T> sequence;
        private final R initialValue;
        private final Func2<R, ? super T, R> accumulatorFunction;

        private Accumulator(Observable<? extends T> sequence, R initialValue, Func2<R, ? super T, R> accumulator) {
            this.sequence = sequence;
            this.initialValue = initialValue;
            this.accumulatorFunction = accumulator;
        }

        @Override
        public Subscription onSubscribe(Observer<? super R> observer) {
            observer.onNext(this.initialValue);
            return this.sequence.subscribe(new AccumulatingObserver(observer, this.initialValue, this.accumulatorFunction));
        }
    }

    private static class AccuWithoutInitialValue<T>
    implements Observable.OnSubscribeFunc<T> {
        private final Observable<? extends T> sequence;
        private final Func2<T, T, T> accumulatorFunction;
        private AccumulatingObserver<T, T> accumulatingObserver;

        private AccuWithoutInitialValue(Observable<? extends T> sequence, Func2<T, T, T> accumulator) {
            this.sequence = sequence;
            this.accumulatorFunction = accumulator;
        }

        @Override
        public Subscription onSubscribe(final Observer<? super T> observer) {
            return this.sequence.subscribe(new Observer<T>(){

                @Override
                public synchronized void onNext(T value) {
                    if (AccuWithoutInitialValue.this.accumulatingObserver == null) {
                        observer.onNext(value);
                        AccuWithoutInitialValue.this.accumulatingObserver = new AccumulatingObserver(observer, value, AccuWithoutInitialValue.this.accumulatorFunction);
                    } else {
                        AccuWithoutInitialValue.this.accumulatingObserver.onNext(value);
                    }
                }

                @Override
                public void onError(Throwable e) {
                    observer.onError(e);
                }

                @Override
                public void onCompleted() {
                    observer.onCompleted();
                }
            });
        }
    }
}

