/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import rx.Observable;
import rx.Observer;
import rx.Subscription;

public final class OperationSkip {
    public static <T> Observable.OnSubscribeFunc<T> skip(final Observable<? extends T> items, final int num) {
        return new Observable.OnSubscribeFunc<T>(){

            @Override
            public Subscription onSubscribe(Observer<? super T> observer) {
                return new Skip(items, num).onSubscribe(observer);
            }
        };
    }

    public static class UnitTest {
        @Test
        public void testSkip1() {
            Observable<String> w = Observable.from("one", "two", "three");
            Observable<String> skip = Observable.create(OperationSkip.skip(w, 2));
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            skip.subscribe(aObserver);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onNext("one");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onNext("two");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext("three");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onCompleted();
        }

        @Test
        public void testSkip2() {
            Observable<String> w = Observable.from("one", "two", "three");
            Observable<String> skip = Observable.create(OperationSkip.skip(w, 1));
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            skip.subscribe(aObserver);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onNext("one");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext("two");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext("three");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onCompleted();
        }
    }

    private static class Skip<T>
    implements Observable.OnSubscribeFunc<T> {
        private final int num;
        private final Observable<? extends T> items;

        Skip(Observable<? extends T> items, int num) {
            this.num = num;
            this.items = items;
        }

        @Override
        public Subscription onSubscribe(Observer<? super T> observer) {
            return this.items.subscribe(new ItemObserver(observer));
        }

        private class ItemObserver
        implements Observer<T> {
            private AtomicInteger counter = new AtomicInteger();
            private final Observer<? super T> observer;

            public ItemObserver(Observer<? super T> observer) {
                this.observer = observer;
            }

            @Override
            public void onCompleted() {
                this.observer.onCompleted();
            }

            @Override
            public void onError(Throwable e) {
                this.observer.onError(e);
            }

            @Override
            public void onNext(T args) {
                if (this.counter.incrementAndGet() > Skip.this.num) {
                    this.observer.onNext(args);
                }
            }
        }
    }
}

