/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.concurrency.TestScheduler;
import rx.operators.SafeObservableSubscription;
import rx.subscriptions.Subscriptions;
import rx.util.functions.Action0;

public final class OperationSwitch {
    public static <T> Observable.OnSubscribeFunc<T> switchDo(final Observable<? extends Observable<? extends T>> sequences) {
        return new Observable.OnSubscribeFunc<T>(){

            @Override
            public Subscription onSubscribe(Observer<? super T> observer) {
                return new Switch(sequences).onSubscribe(observer);
            }
        };
    }

    public static class UnitTest {
        private TestScheduler scheduler;
        private Observer<String> observer;

        @Before
        public void before() {
            this.scheduler = new TestScheduler();
            this.observer = (Observer)Mockito.mock(Observer.class);
        }

        @Test
        public void testSwitchWithComplete() {
            Observable<Observable<String>> source = Observable.create(new Observable.OnSubscribeFunc<Observable<String>>(){

                @Override
                public Subscription onSubscribe(Observer<? super Observable<String>> observer) {
                    UnitTest.this.publishNext(observer, 50L, Observable.create(new Observable.OnSubscribeFunc<String>(){

                        @Override
                        public Subscription onSubscribe(Observer<? super String> observer) {
                            UnitTest.this.publishNext(observer, 50L, "one");
                            UnitTest.this.publishNext(observer, 100L, "two");
                            return Subscriptions.empty();
                        }
                    }));
                    UnitTest.this.publishNext(observer, 200L, Observable.create(new Observable.OnSubscribeFunc<String>(){

                        @Override
                        public Subscription onSubscribe(Observer<? super String> observer) {
                            UnitTest.this.publishNext(observer, 0L, "three");
                            UnitTest.this.publishNext(observer, 100L, "four");
                            return Subscriptions.empty();
                        }
                    }));
                    UnitTest.this.publishCompleted(observer, 250L);
                    return Subscriptions.empty();
                }
            });
            Observable<String> sampled = Observable.create(OperationSwitch.switchDo(source));
            sampled.subscribe(this.observer);
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.observer});
            this.scheduler.advanceTimeTo(90L, TimeUnit.MILLISECONDS);
            ((Observer)inOrder.verify(this.observer, Mockito.never())).onNext(Mockito.anyString());
            ((Observer)Mockito.verify(this.observer, (VerificationMode)Mockito.never())).onCompleted();
            ((Observer)Mockito.verify(this.observer, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            this.scheduler.advanceTimeTo(125L, TimeUnit.MILLISECONDS);
            ((Observer)inOrder.verify(this.observer, Mockito.times((int)1))).onNext("one");
            ((Observer)Mockito.verify(this.observer, (VerificationMode)Mockito.never())).onCompleted();
            ((Observer)Mockito.verify(this.observer, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            this.scheduler.advanceTimeTo(175L, TimeUnit.MILLISECONDS);
            ((Observer)inOrder.verify(this.observer, Mockito.times((int)1))).onNext("two");
            ((Observer)Mockito.verify(this.observer, (VerificationMode)Mockito.never())).onCompleted();
            ((Observer)Mockito.verify(this.observer, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            this.scheduler.advanceTimeTo(225L, TimeUnit.MILLISECONDS);
            ((Observer)inOrder.verify(this.observer, Mockito.times((int)1))).onNext("three");
            ((Observer)Mockito.verify(this.observer, (VerificationMode)Mockito.never())).onCompleted();
            ((Observer)Mockito.verify(this.observer, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            this.scheduler.advanceTimeTo(350L, TimeUnit.MILLISECONDS);
            ((Observer)inOrder.verify(this.observer, Mockito.never())).onNext(Mockito.anyString());
            ((Observer)Mockito.verify(this.observer, (VerificationMode)Mockito.times((int)1))).onCompleted();
            ((Observer)Mockito.verify(this.observer, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
        }

        @Test
        public void testSwitchWithError() {
            Observable<Observable<String>> source = Observable.create(new Observable.OnSubscribeFunc<Observable<String>>(){

                @Override
                public Subscription onSubscribe(Observer<? super Observable<String>> observer) {
                    UnitTest.this.publishNext(observer, 50L, Observable.create(new Observable.OnSubscribeFunc<String>(){

                        @Override
                        public Subscription onSubscribe(Observer<? super String> observer) {
                            UnitTest.this.publishNext(observer, 50L, "one");
                            UnitTest.this.publishNext(observer, 100L, "two");
                            return Subscriptions.empty();
                        }
                    }));
                    UnitTest.this.publishNext(observer, 200L, Observable.create(new Observable.OnSubscribeFunc<String>(){

                        @Override
                        public Subscription onSubscribe(Observer<? super String> observer) {
                            UnitTest.this.publishNext(observer, 0L, "three");
                            UnitTest.this.publishNext(observer, 100L, "four");
                            return Subscriptions.empty();
                        }
                    }));
                    UnitTest.this.publishError(observer, 250L, new TestException());
                    return Subscriptions.empty();
                }
            });
            Observable<String> sampled = Observable.create(OperationSwitch.switchDo(source));
            sampled.subscribe(this.observer);
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.observer});
            this.scheduler.advanceTimeTo(90L, TimeUnit.MILLISECONDS);
            ((Observer)inOrder.verify(this.observer, Mockito.never())).onNext(Mockito.anyString());
            ((Observer)Mockito.verify(this.observer, (VerificationMode)Mockito.never())).onCompleted();
            ((Observer)Mockito.verify(this.observer, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            this.scheduler.advanceTimeTo(125L, TimeUnit.MILLISECONDS);
            ((Observer)inOrder.verify(this.observer, Mockito.times((int)1))).onNext("one");
            ((Observer)Mockito.verify(this.observer, (VerificationMode)Mockito.never())).onCompleted();
            ((Observer)Mockito.verify(this.observer, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            this.scheduler.advanceTimeTo(175L, TimeUnit.MILLISECONDS);
            ((Observer)inOrder.verify(this.observer, Mockito.times((int)1))).onNext("two");
            ((Observer)Mockito.verify(this.observer, (VerificationMode)Mockito.never())).onCompleted();
            ((Observer)Mockito.verify(this.observer, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            this.scheduler.advanceTimeTo(225L, TimeUnit.MILLISECONDS);
            ((Observer)inOrder.verify(this.observer, Mockito.times((int)1))).onNext("three");
            ((Observer)Mockito.verify(this.observer, (VerificationMode)Mockito.never())).onCompleted();
            ((Observer)Mockito.verify(this.observer, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            this.scheduler.advanceTimeTo(350L, TimeUnit.MILLISECONDS);
            ((Observer)inOrder.verify(this.observer, Mockito.never())).onNext(Mockito.anyString());
            ((Observer)Mockito.verify(this.observer, (VerificationMode)Mockito.never())).onCompleted();
            ((Observer)Mockito.verify(this.observer, (VerificationMode)Mockito.times((int)1))).onError((Throwable)Mockito.any(TestException.class));
        }

        @Test
        public void testSwitchWithSubsequenceComplete() {
            Observable<Observable<String>> source = Observable.create(new Observable.OnSubscribeFunc<Observable<String>>(){

                @Override
                public Subscription onSubscribe(Observer<? super Observable<String>> observer) {
                    UnitTest.this.publishNext(observer, 50L, Observable.create(new Observable.OnSubscribeFunc<String>(){

                        @Override
                        public Subscription onSubscribe(Observer<? super String> observer) {
                            UnitTest.this.publishNext(observer, 50L, "one");
                            UnitTest.this.publishNext(observer, 100L, "two");
                            return Subscriptions.empty();
                        }
                    }));
                    UnitTest.this.publishNext(observer, 130L, Observable.create(new Observable.OnSubscribeFunc<String>(){

                        @Override
                        public Subscription onSubscribe(Observer<? super String> observer) {
                            UnitTest.this.publishCompleted(observer, 0L);
                            return Subscriptions.empty();
                        }
                    }));
                    UnitTest.this.publishNext(observer, 150L, Observable.create(new Observable.OnSubscribeFunc<String>(){

                        @Override
                        public Subscription onSubscribe(Observer<? super String> observer) {
                            UnitTest.this.publishNext(observer, 50L, "three");
                            return Subscriptions.empty();
                        }
                    }));
                    return Subscriptions.empty();
                }
            });
            Observable<String> sampled = Observable.create(OperationSwitch.switchDo(source));
            sampled.subscribe(this.observer);
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.observer});
            this.scheduler.advanceTimeTo(90L, TimeUnit.MILLISECONDS);
            ((Observer)inOrder.verify(this.observer, Mockito.never())).onNext(Mockito.anyString());
            ((Observer)Mockito.verify(this.observer, (VerificationMode)Mockito.never())).onCompleted();
            ((Observer)Mockito.verify(this.observer, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            this.scheduler.advanceTimeTo(125L, TimeUnit.MILLISECONDS);
            ((Observer)inOrder.verify(this.observer, Mockito.times((int)1))).onNext("one");
            ((Observer)Mockito.verify(this.observer, (VerificationMode)Mockito.never())).onCompleted();
            ((Observer)Mockito.verify(this.observer, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            this.scheduler.advanceTimeTo(250L, TimeUnit.MILLISECONDS);
            ((Observer)inOrder.verify(this.observer, Mockito.times((int)1))).onNext("three");
            ((Observer)Mockito.verify(this.observer, (VerificationMode)Mockito.never())).onCompleted();
            ((Observer)Mockito.verify(this.observer, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
        }

        @Test
        public void testSwitchWithSubsequenceError() {
            Observable<Observable<String>> source = Observable.create(new Observable.OnSubscribeFunc<Observable<String>>(){

                @Override
                public Subscription onSubscribe(Observer<? super Observable<String>> observer) {
                    UnitTest.this.publishNext(observer, 50L, Observable.create(new Observable.OnSubscribeFunc<String>(){

                        @Override
                        public Subscription onSubscribe(Observer<? super String> observer) {
                            UnitTest.this.publishNext(observer, 50L, "one");
                            UnitTest.this.publishNext(observer, 100L, "two");
                            return Subscriptions.empty();
                        }
                    }));
                    UnitTest.this.publishNext(observer, 130L, Observable.create(new Observable.OnSubscribeFunc<String>(){

                        @Override
                        public Subscription onSubscribe(Observer<? super String> observer) {
                            UnitTest.this.publishError(observer, 0L, new TestException());
                            return Subscriptions.empty();
                        }
                    }));
                    UnitTest.this.publishNext(observer, 150L, Observable.create(new Observable.OnSubscribeFunc<String>(){

                        @Override
                        public Subscription onSubscribe(Observer<? super String> observer) {
                            UnitTest.this.publishNext(observer, 50L, "three");
                            return Subscriptions.empty();
                        }
                    }));
                    return Subscriptions.empty();
                }
            });
            Observable<String> sampled = Observable.create(OperationSwitch.switchDo(source));
            sampled.subscribe(this.observer);
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.observer});
            this.scheduler.advanceTimeTo(90L, TimeUnit.MILLISECONDS);
            ((Observer)inOrder.verify(this.observer, Mockito.never())).onNext(Mockito.anyString());
            ((Observer)Mockito.verify(this.observer, (VerificationMode)Mockito.never())).onCompleted();
            ((Observer)Mockito.verify(this.observer, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            this.scheduler.advanceTimeTo(125L, TimeUnit.MILLISECONDS);
            ((Observer)inOrder.verify(this.observer, Mockito.times((int)1))).onNext("one");
            ((Observer)Mockito.verify(this.observer, (VerificationMode)Mockito.never())).onCompleted();
            ((Observer)Mockito.verify(this.observer, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            this.scheduler.advanceTimeTo(250L, TimeUnit.MILLISECONDS);
            ((Observer)inOrder.verify(this.observer, Mockito.never())).onNext("three");
            ((Observer)Mockito.verify(this.observer, (VerificationMode)Mockito.never())).onCompleted();
            ((Observer)Mockito.verify(this.observer, (VerificationMode)Mockito.times((int)1))).onError((Throwable)Mockito.any(TestException.class));
        }

        private <T> void publishCompleted(final Observer<T> observer, long delay) {
            this.scheduler.schedule(new Action0(){

                @Override
                public void call() {
                    observer.onCompleted();
                }
            }, delay, TimeUnit.MILLISECONDS);
        }

        private <T> void publishError(final Observer<T> observer, long delay, final Throwable error) {
            this.scheduler.schedule(new Action0(){

                @Override
                public void call() {
                    observer.onError(error);
                }
            }, delay, TimeUnit.MILLISECONDS);
        }

        private <T> void publishNext(final Observer<T> observer, long delay, final T value) {
            this.scheduler.schedule(new Action0(){

                @Override
                public void call() {
                    observer.onNext(value);
                }
            }, delay, TimeUnit.MILLISECONDS);
        }

        private class TestException
        extends Throwable {
            private TestException() {
            }
        }
    }

    private static class SwitchObserver<T>
    implements Observer<Observable<? extends T>> {
        private final Observer<? super T> observer;
        private final SafeObservableSubscription parent;
        private final AtomicReference<Subscription> subsequence = new AtomicReference();

        public SwitchObserver(Observer<? super T> observer, SafeObservableSubscription parent) {
            this.observer = observer;
            this.parent = parent;
        }

        @Override
        public void onCompleted() {
            this.unsubscribeFromSubSequence();
            this.observer.onCompleted();
        }

        @Override
        public void onError(Throwable e) {
            this.unsubscribeFromSubSequence();
            this.observer.onError(e);
        }

        @Override
        public void onNext(Observable<? extends T> args) {
            this.unsubscribeFromSubSequence();
            this.subsequence.set(args.subscribe(new Observer<T>(){

                @Override
                public void onCompleted() {
                }

                @Override
                public void onError(Throwable e) {
                    SwitchObserver.this.parent.unsubscribe();
                    SwitchObserver.this.observer.onError(e);
                }

                @Override
                public void onNext(T args) {
                    SwitchObserver.this.observer.onNext(args);
                }
            }));
        }

        private void unsubscribeFromSubSequence() {
            Subscription previousSubscription = this.subsequence.get();
            if (previousSubscription != null) {
                previousSubscription.unsubscribe();
            }
        }
    }

    private static class Switch<T>
    implements Observable.OnSubscribeFunc<T> {
        private final Observable<? extends Observable<? extends T>> sequences;

        public Switch(Observable<? extends Observable<? extends T>> sequences) {
            this.sequences = sequences;
        }

        @Override
        public Subscription onSubscribe(Observer<? super T> observer) {
            SafeObservableSubscription subscription = new SafeObservableSubscription();
            subscription.wrap(this.sequences.subscribe(new SwitchObserver<T>(observer, subscription)));
            return subscription;
        }
    }
}

