/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.Iterator;
import java.util.concurrent.LinkedBlockingDeque;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.operators.SafeObservableSubscription;

public final class OperationTakeLast {
    public static <T> Observable.OnSubscribeFunc<T> takeLast(final Observable<? extends T> items, final int count) {
        return new Observable.OnSubscribeFunc<T>(){

            @Override
            public Subscription onSubscribe(Observer<? super T> observer) {
                return new TakeLast(items, count).onSubscribe(observer);
            }
        };
    }

    public static class UnitTest {
        @Test
        public void testTakeLastEmpty() {
            Observable w = Observable.empty();
            Observable take = Observable.create(OperationTakeLast.takeLast(w, 2));
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            take.subscribe(aObserver);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onNext(Mockito.any(String.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onCompleted();
        }

        @Test
        public void testTakeLast1() {
            Observable<String> w = Observable.from("one", "two", "three");
            Observable<String> take = Observable.create(OperationTakeLast.takeLast(w, 2));
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{aObserver});
            take.subscribe(aObserver);
            ((Observer)inOrder.verify((Object)aObserver, Mockito.times((int)1))).onNext("two");
            ((Observer)inOrder.verify((Object)aObserver, Mockito.times((int)1))).onNext("three");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onNext("one");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onCompleted();
        }

        @Test
        public void testTakeLast2() {
            Observable<String> w = Observable.from("one");
            Observable<String> take = Observable.create(OperationTakeLast.takeLast(w, 10));
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            take.subscribe(aObserver);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext("one");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onCompleted();
        }
    }

    private static class TakeLast<T>
    implements Observable.OnSubscribeFunc<T> {
        private final int count;
        private final Observable<? extends T> items;
        private final SafeObservableSubscription subscription = new SafeObservableSubscription();

        TakeLast(Observable<? extends T> items, int count) {
            this.count = count;
            this.items = items;
        }

        @Override
        public Subscription onSubscribe(Observer<? super T> observer) {
            return this.subscription.wrap(this.items.subscribe(new ItemObserver(observer)));
        }

        private class ItemObserver
        implements Observer<T> {
            private LinkedBlockingDeque<T> deque;
            private final Observer<? super T> observer;

            public ItemObserver(Observer<? super T> observer) {
                this.deque = new LinkedBlockingDeque(TakeLast.this.count);
                this.observer = observer;
            }

            @Override
            public void onCompleted() {
                Iterator reverse = this.deque.descendingIterator();
                while (reverse.hasNext()) {
                    this.observer.onNext(reverse.next());
                }
                this.observer.onCompleted();
            }

            @Override
            public void onError(Throwable e) {
                this.observer.onError(e);
            }

            @Override
            public void onNext(T args) {
                while (!this.deque.offerFirst(args)) {
                    this.deque.removeLast();
                }
            }
        }
    }
}

