/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.util.functions.Func1;

public class OperationTakeUntil {
    public static <T, E> Observable<T> takeUntil(Observable<? extends T> source, Observable<? extends E> other) {
        Observable s = Observable.create(new SourceObservable(source));
        Observable o = Observable.create(new OtherObservable(other));
        Observable result = Observable.merge(s, o);
        return result.takeWhile(new Func1<Notification<T>, Boolean>(){

            @Override
            public Boolean call(Notification<T> notification) {
                return !notification.halt;
            }
        }).map(new Func1<Notification<T>, T>(){

            @Override
            public T call(Notification<T> notification) {
                return notification.value;
            }
        });
    }

    public static class UnitTest {
        @Test
        public void testTakeUntil() {
            Subscription sSource = (Subscription)Mockito.mock(Subscription.class);
            Subscription sOther = (Subscription)Mockito.mock(Subscription.class);
            TestObservable source = new TestObservable(sSource);
            TestObservable other = new TestObservable(sOther);
            Observer result = (Observer)Mockito.mock(Observer.class);
            Observable<String> stringObservable = OperationTakeUntil.takeUntil(Observable.create(source), Observable.create(other));
            stringObservable.subscribe(result);
            source.sendOnNext("one");
            source.sendOnNext("two");
            other.sendOnNext("three");
            source.sendOnNext("four");
            source.sendOnCompleted();
            other.sendOnCompleted();
            ((Observer)Mockito.verify((Object)result, (VerificationMode)Mockito.times((int)1))).onNext("one");
            ((Observer)Mockito.verify((Object)result, (VerificationMode)Mockito.times((int)1))).onNext("two");
            ((Observer)Mockito.verify((Object)result, (VerificationMode)Mockito.times((int)0))).onNext("three");
            ((Observer)Mockito.verify((Object)result, (VerificationMode)Mockito.times((int)0))).onNext("four");
            ((Subscription)Mockito.verify((Object)sSource, (VerificationMode)Mockito.times((int)1))).unsubscribe();
            ((Subscription)Mockito.verify((Object)sOther, (VerificationMode)Mockito.times((int)1))).unsubscribe();
        }

        @Test
        public void testTakeUntilSourceCompleted() {
            Subscription sSource = (Subscription)Mockito.mock(Subscription.class);
            Subscription sOther = (Subscription)Mockito.mock(Subscription.class);
            TestObservable source = new TestObservable(sSource);
            TestObservable other = new TestObservable(sOther);
            Observer result = (Observer)Mockito.mock(Observer.class);
            Observable<String> stringObservable = OperationTakeUntil.takeUntil(Observable.create(source), Observable.create(other));
            stringObservable.subscribe(result);
            source.sendOnNext("one");
            source.sendOnNext("two");
            source.sendOnCompleted();
            ((Observer)Mockito.verify((Object)result, (VerificationMode)Mockito.times((int)1))).onNext("one");
            ((Observer)Mockito.verify((Object)result, (VerificationMode)Mockito.times((int)1))).onNext("two");
            ((Subscription)Mockito.verify((Object)sSource, (VerificationMode)Mockito.times((int)1))).unsubscribe();
            ((Subscription)Mockito.verify((Object)sOther, (VerificationMode)Mockito.times((int)1))).unsubscribe();
        }

        @Test
        public void testTakeUntilSourceError() {
            Subscription sSource = (Subscription)Mockito.mock(Subscription.class);
            Subscription sOther = (Subscription)Mockito.mock(Subscription.class);
            TestObservable source = new TestObservable(sSource);
            TestObservable other = new TestObservable(sOther);
            Throwable error = new Throwable();
            Observer result = (Observer)Mockito.mock(Observer.class);
            Observable<String> stringObservable = OperationTakeUntil.takeUntil(Observable.create(source), Observable.create(other));
            stringObservable.subscribe(result);
            source.sendOnNext("one");
            source.sendOnNext("two");
            source.sendOnError(error);
            ((Observer)Mockito.verify((Object)result, (VerificationMode)Mockito.times((int)1))).onNext("one");
            ((Observer)Mockito.verify((Object)result, (VerificationMode)Mockito.times((int)1))).onNext("two");
            ((Observer)Mockito.verify((Object)result, (VerificationMode)Mockito.times((int)1))).onError(error);
            ((Subscription)Mockito.verify((Object)sSource, (VerificationMode)Mockito.times((int)1))).unsubscribe();
            ((Subscription)Mockito.verify((Object)sOther, (VerificationMode)Mockito.times((int)1))).unsubscribe();
        }

        @Test
        public void testTakeUntilOtherError() {
            Subscription sSource = (Subscription)Mockito.mock(Subscription.class);
            Subscription sOther = (Subscription)Mockito.mock(Subscription.class);
            TestObservable source = new TestObservable(sSource);
            TestObservable other = new TestObservable(sOther);
            Throwable error = new Throwable();
            Observer result = (Observer)Mockito.mock(Observer.class);
            Observable<String> stringObservable = OperationTakeUntil.takeUntil(Observable.create(source), Observable.create(other));
            stringObservable.subscribe(result);
            source.sendOnNext("one");
            source.sendOnNext("two");
            other.sendOnError(error);
            ((Observer)Mockito.verify((Object)result, (VerificationMode)Mockito.times((int)1))).onNext("one");
            ((Observer)Mockito.verify((Object)result, (VerificationMode)Mockito.times((int)1))).onNext("two");
            ((Observer)Mockito.verify((Object)result, (VerificationMode)Mockito.times((int)1))).onError(error);
            ((Observer)Mockito.verify((Object)result, (VerificationMode)Mockito.times((int)0))).onCompleted();
            ((Subscription)Mockito.verify((Object)sSource, (VerificationMode)Mockito.times((int)1))).unsubscribe();
            ((Subscription)Mockito.verify((Object)sOther, (VerificationMode)Mockito.times((int)1))).unsubscribe();
        }

        @Test
        public void testTakeUntilOtherCompleted() {
            Subscription sSource = (Subscription)Mockito.mock(Subscription.class);
            Subscription sOther = (Subscription)Mockito.mock(Subscription.class);
            TestObservable source = new TestObservable(sSource);
            TestObservable other = new TestObservable(sOther);
            Observer result = (Observer)Mockito.mock(Observer.class);
            Observable<String> stringObservable = OperationTakeUntil.takeUntil(Observable.create(source), Observable.create(other));
            stringObservable.subscribe(result);
            source.sendOnNext("one");
            source.sendOnNext("two");
            other.sendOnCompleted();
            ((Observer)Mockito.verify((Object)result, (VerificationMode)Mockito.times((int)1))).onNext("one");
            ((Observer)Mockito.verify((Object)result, (VerificationMode)Mockito.times((int)1))).onNext("two");
            ((Observer)Mockito.verify((Object)result, (VerificationMode)Mockito.times((int)0))).onCompleted();
            ((Subscription)Mockito.verify((Object)sSource, (VerificationMode)Mockito.times((int)0))).unsubscribe();
            ((Subscription)Mockito.verify((Object)sOther, (VerificationMode)Mockito.times((int)0))).unsubscribe();
        }

        private static class TestObservable
        implements Observable.OnSubscribeFunc<String> {
            Observer<? super String> observer = null;
            Subscription s;

            public TestObservable(Subscription s) {
                this.s = s;
            }

            public void sendOnCompleted() {
                this.observer.onCompleted();
            }

            public void sendOnNext(String value) {
                this.observer.onNext(value);
            }

            public void sendOnError(Throwable e) {
                this.observer.onError(e);
            }

            @Override
            public Subscription onSubscribe(Observer<? super String> observer) {
                this.observer = observer;
                return this.s;
            }
        }
    }

    private static class OtherObservable<T, E>
    implements Observable.OnSubscribeFunc<Notification<T>> {
        private final Observable<? extends E> sequence;

        private OtherObservable(Observable<? extends E> sequence) {
            this.sequence = sequence;
        }

        @Override
        public Subscription onSubscribe(final Observer<? super Notification<T>> notificationObserver) {
            return this.sequence.subscribe(new Observer<E>(){

                @Override
                public void onCompleted() {
                }

                @Override
                public void onError(Throwable e) {
                    notificationObserver.onError(e);
                }

                @Override
                public void onNext(E args) {
                    notificationObserver.onNext(Notification.halt());
                }
            });
        }
    }

    private static class SourceObservable<T>
    implements Observable.OnSubscribeFunc<Notification<T>> {
        private final Observable<? extends T> sequence;

        private SourceObservable(Observable<? extends T> sequence) {
            this.sequence = sequence;
        }

        @Override
        public Subscription onSubscribe(final Observer<? super Notification<T>> notificationObserver) {
            return this.sequence.subscribe(new Observer<T>(){

                @Override
                public void onCompleted() {
                    notificationObserver.onNext(Notification.halt());
                }

                @Override
                public void onError(Throwable e) {
                    notificationObserver.onError(e);
                }

                @Override
                public void onNext(T args) {
                    notificationObserver.onNext(Notification.value(args));
                }
            });
        }
    }

    private static class Notification<T> {
        private final boolean halt;
        private final T value;

        public static <T> Notification<T> value(T value) {
            return new Notification<T>(false, value);
        }

        public static <T> Notification<T> halt() {
            return new Notification<Object>(true, null);
        }

        private Notification(boolean halt, T value) {
            this.halt = halt;
            this.value = value;
        }
    }
}

