/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.Arrays;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.subscriptions.Subscriptions;

public final class OperationToObservableIterable<T> {
    public static <T> Observable.OnSubscribeFunc<T> toObservableIterable(Iterable<? extends T> list) {
        return new ToObservableIterable<T>(list);
    }

    public static class UnitTest {
        @Test
        public void testIterable() {
            Observable<String> observable = Observable.create(OperationToObservableIterable.toObservableIterable(Arrays.asList("one", "two", "three")));
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            observable.subscribe(aObserver);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext("one");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext("two");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext("three");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onCompleted();
        }
    }

    private static class ToObservableIterable<T>
    implements Observable.OnSubscribeFunc<T> {
        public Iterable<? extends T> iterable;

        public ToObservableIterable(Iterable<? extends T> list) {
            this.iterable = list;
        }

        @Override
        public Subscription onSubscribe(Observer<? super T> observer) {
            for (T item : this.iterable) {
                observer.onNext(item);
            }
            observer.onCompleted();
            return Subscriptions.empty();
        }
    }
}

