/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.util.functions.Func2;

public final class OperationToObservableSortedList<T> {
    public static <T> Observable.OnSubscribeFunc<List<T>> toSortedList(Observable<? extends T> sequence) {
        return new ToObservableSortedList((Observable)sequence);
    }

    public static <T> Observable.OnSubscribeFunc<List<T>> toSortedList(Observable<? extends T> sequence, Func2<? super T, ? super T, Integer> sortFunction) {
        return new ToObservableSortedList(sequence, sortFunction);
    }

    public static class UnitTest {
        @Test
        public void testSortedList() {
            Observable<Integer> w = Observable.from(1, 3, 2, 5, 4);
            Observable<List<Integer>> observable = Observable.create(OperationToObservableSortedList.toSortedList(w));
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            observable.subscribe(aObserver);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext(Arrays.asList(1, 2, 3, 4, 5));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onCompleted();
        }

        @Test
        public void testSortedListWithCustomFunction() {
            Observable<Integer> w = Observable.from(1, 3, 2, 5, 4);
            Observable<List<Integer>> observable = Observable.create(OperationToObservableSortedList.toSortedList(w, new Func2<Integer, Integer, Integer>(){

                @Override
                public Integer call(Integer t1, Integer t2) {
                    return t2 - t1;
                }
            }));
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            observable.subscribe(aObserver);
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext(Arrays.asList(5, 4, 3, 2, 1));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onCompleted();
        }
    }

    private static class ToObservableSortedList<T>
    implements Observable.OnSubscribeFunc<List<T>> {
        private final Observable<? extends T> that;
        private final ConcurrentLinkedQueue<T> list = new ConcurrentLinkedQueue();
        private final Func2<? super T, ? super T, Integer> sortFunction;
        private static Func2 defaultSortFunction = new DefaultComparableFunction();

        private ToObservableSortedList(Observable<? extends T> that) {
            this(that, defaultSortFunction);
        }

        private ToObservableSortedList(Observable<? extends T> that, Func2<? super T, ? super T, Integer> sortFunction) {
            this.that = that;
            this.sortFunction = sortFunction;
        }

        @Override
        public Subscription onSubscribe(final Observer<? super List<T>> observer) {
            return this.that.subscribe(new Observer<T>(){

                @Override
                public void onNext(T value) {
                    ToObservableSortedList.this.list.add(value);
                }

                @Override
                public void onError(Throwable ex) {
                    observer.onError(ex);
                }

                @Override
                public void onCompleted() {
                    try {
                        ArrayList l = new ArrayList(ToObservableSortedList.this.list.size());
                        for (Object t : ToObservableSortedList.this.list) {
                            l.add(t);
                        }
                        Collections.sort(l, new Comparator<T>(){

                            @Override
                            public int compare(T o1, T o2) {
                                return (Integer)ToObservableSortedList.this.sortFunction.call(o1, o2);
                            }
                        });
                        observer.onNext(Collections.unmodifiableList(l));
                        observer.onCompleted();
                    }
                    catch (Throwable e) {
                        this.onError(e);
                    }
                }
            });
        }

        private static class DefaultComparableFunction
        implements Func2<Object, Object, Integer> {
            private DefaultComparableFunction() {
            }

            @Override
            public Integer call(Object t1, Object t2) {
                Comparable c1 = (Comparable)t1;
                Comparable c2 = (Comparable)t2;
                return c1.compareTo(c2);
            }
        }
    }
}

