/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.Comparator;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.subscriptions.Subscriptions;
import rx.util.functions.Action0;
import rx.util.functions.Func1;
import rx.util.functions.Functions;

public final class OperationDistinctUntilChanged {
    public static <T> Observable.OnSubscribeFunc<T> distinctUntilChanged(Observable<? extends T> source, Comparator<T> equalityComparator) {
        return new DistinctUntilChanged(source, Functions.identity(), equalityComparator);
    }

    public static <T, U> Observable.OnSubscribeFunc<T> distinctUntilChanged(Observable<? extends T> source, Func1<? super T, ? extends U> keySelector, Comparator<U> equalityComparator) {
        return new DistinctUntilChanged(source, keySelector, equalityComparator);
    }

    public static <T, U> Observable.OnSubscribeFunc<T> distinctUntilChanged(Observable<? extends T> source, Func1<? super T, ? extends U> keySelector) {
        return new DistinctUntilChanged(source, keySelector, new DefaultEqualityComparator());
    }

    public static <T> Observable.OnSubscribeFunc<T> distinctUntilChanged(Observable<? extends T> source) {
        return new DistinctUntilChanged(source, Functions.identity(), new DefaultEqualityComparator());
    }

    private static class DistinctUntilChanged<T, U>
    implements Observable.OnSubscribeFunc<T> {
        private final Observable<? extends T> source;
        private final Func1<? super T, ? extends U> keySelector;
        private final Comparator<U> equalityComparator;

        private DistinctUntilChanged(Observable<? extends T> source, Func1<? super T, ? extends U> keySelector, Comparator<U> equalityComparator) {
            this.source = source;
            this.keySelector = keySelector;
            this.equalityComparator = equalityComparator;
        }

        @Override
        public Subscription onSubscribe(final Observer<? super T> observer) {
            final Subscription sourceSub = this.source.subscribe(new Observer<T>(){
                private U lastEmittedKey;
                private boolean hasEmitted;

                @Override
                public void onCompleted() {
                    observer.onCompleted();
                }

                @Override
                public void onError(Throwable e) {
                    observer.onError(e);
                }

                @Override
                public void onNext(T next) {
                    Object lastKey = this.lastEmittedKey;
                    Object nextKey = DistinctUntilChanged.this.keySelector.call(next);
                    this.lastEmittedKey = nextKey;
                    if (!this.hasEmitted) {
                        this.hasEmitted = true;
                        observer.onNext(next);
                    } else if (DistinctUntilChanged.this.equalityComparator.compare(lastKey, nextKey) != 0) {
                        observer.onNext(next);
                    }
                }
            });
            return Subscriptions.create(new Action0(){

                @Override
                public void call() {
                    sourceSub.unsubscribe();
                }
            });
        }
    }

    private static class DefaultEqualityComparator<T>
    implements Comparator<T> {
        private DefaultEqualityComparator() {
        }

        @Override
        public int compare(T t1, T t2) {
            if (t1 == null) {
                return t2 == null ? 0 : 1;
            }
            return t1.equals(t2) ? 0 : 1;
        }
    }
}

