/*
 * Decompiled with CFR 0.152.
 */
package rx.subjects;

import org.junit.Assert;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.util.functions.Action1;
import rx.util.functions.Func0;

class UnsubscribeTester {
    private boolean isDone = false;
    private Subscription subscription;

    public static <T, O extends Observable<T>> void test(Func0<? extends O> provider, Action1<? super O> generateOnCompleted, Action1<? super O> generateOnError, Action1<? super O> generateOnNext) {
        UnsubscribeTester tester2;
        UnsubscribeTester tester1;
        Observable observable;
        if (generateOnCompleted != null) {
            observable = (Observable)provider.call();
            tester1 = UnsubscribeTester.createOnCompleted(observable);
            tester2 = UnsubscribeTester.createOnCompleted(observable);
            generateOnCompleted.call(observable);
            tester1.assertPassed();
            tester2.assertPassed();
        }
        if (generateOnError != null) {
            observable = (Observable)provider.call();
            tester1 = UnsubscribeTester.createOnError(observable);
            tester2 = UnsubscribeTester.createOnError(observable);
            generateOnError.call(observable);
            tester1.assertPassed();
            tester2.assertPassed();
        }
        if (generateOnNext != null) {
            observable = (Observable)provider.call();
            tester1 = UnsubscribeTester.createOnNext(observable);
            tester2 = UnsubscribeTester.createOnNext(observable);
            generateOnNext.call(observable);
            tester1.assertPassed();
            tester2.assertPassed();
        }
    }

    private static <T> UnsubscribeTester createOnCompleted(Observable<T> observable) {
        final UnsubscribeTester test = new UnsubscribeTester();
        test.setSubscription(observable.subscribe(new Observer<T>(){

            @Override
            public void onCompleted() {
                test.doUnsubscribe("onCompleted");
            }

            @Override
            public void onError(Throwable e) {
                test.gotEvent("onError");
            }

            @Override
            public void onNext(T args) {
                test.gotEvent("onNext");
            }
        }));
        return test;
    }

    private static <T> UnsubscribeTester createOnError(Observable<T> observable) {
        final UnsubscribeTester test = new UnsubscribeTester();
        test.setSubscription(observable.subscribe(new Observer<T>(){

            @Override
            public void onCompleted() {
                test.gotEvent("onCompleted");
            }

            @Override
            public void onError(Throwable e) {
                test.doUnsubscribe("onError");
            }

            @Override
            public void onNext(T args) {
                test.gotEvent("onNext");
            }
        }));
        return test;
    }

    private static <T> UnsubscribeTester createOnNext(Observable<T> observable) {
        final UnsubscribeTester test = new UnsubscribeTester();
        test.setSubscription(observable.subscribe(new Observer<T>(){

            @Override
            public void onCompleted() {
                test.gotEvent("onCompleted");
            }

            @Override
            public void onError(Throwable e) {
                test.gotEvent("onError");
            }

            @Override
            public void onNext(T args) {
                test.doUnsubscribe("onNext");
            }
        }));
        return test;
    }

    private void setSubscription(Subscription subscription) {
        this.subscription = subscription;
    }

    private void gotEvent(String event) {
        Assert.assertFalse((String)("received " + event + " after unsubscribe"), (boolean)this.isDone);
    }

    private void doUnsubscribe(String event) {
        this.gotEvent(event);
        if (this.subscription != null) {
            this.isDone = true;
            this.subscription.unsubscribe();
        }
    }

    private void assertPassed() {
        Assert.assertTrue((String)"expected notification was received", (boolean)this.isDone);
    }
}

