/*
 * Decompiled with CFR 0.152.
 */
package rx.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

public final class Range
implements Iterable<Integer> {
    private final int start;
    private final int end;
    private final int step;

    public static Range createWithCount(int start, int count) {
        return Range.create(start, start + count);
    }

    public static Range create(int start, int end) {
        return new Range(start, end, 1);
    }

    public static Range createWithStep(int start, int end, int step) {
        return new Range(start, end, step);
    }

    private Range(int start, int end, int step) {
        this.start = start;
        this.end = end;
        this.step = step;
    }

    @Override
    public Iterator<Integer> iterator() {
        return new Iterator<Integer>(){
            private int current;
            {
                this.current = Range.this.start;
            }

            @Override
            public boolean hasNext() {
                return this.current < Range.this.end;
            }

            @Override
            public Integer next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No more elements");
                }
                int result = this.current;
                this.current += Range.this.step;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Read only iterator");
            }
        };
    }

    public String toString() {
        return "Range (" + this.start + ", " + this.end + "), step " + this.step;
    }
}

