/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.concurrent.atomic.AtomicBoolean;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.subjects.ReplaySubject;

public class OperationCache {
    public static <T> Observable.OnSubscribeFunc<T> cache(final Observable<? extends T> source) {
        return new Observable.OnSubscribeFunc<T>(){
            final AtomicBoolean subscribed = new AtomicBoolean(false);
            private final ReplaySubject<T> cache = ReplaySubject.create();

            @Override
            public Subscription onSubscribe(Observer<? super T> observer) {
                if (this.subscribed.compareAndSet(false, true)) {
                    source.subscribe(this.cache);
                }
                return this.cache.subscribe(observer);
            }
        };
    }
}

