/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import rx.Observable;
import rx.Observer;
import rx.Scheduler;
import rx.Subscription;
import rx.concurrency.Schedulers;
import rx.operators.SynchronizedObserver;
import rx.util.functions.Action0;

public final class OperationDebounce {
    public static <T> Observable.OnSubscribeFunc<T> debounce(Observable<T> items, long timeout, TimeUnit unit) {
        return OperationDebounce.debounce(items, timeout, unit, Schedulers.threadPoolForComputation());
    }

    public static <T> Observable.OnSubscribeFunc<T> debounce(final Observable<T> items, final long timeout, final TimeUnit unit, final Scheduler scheduler) {
        return new Observable.OnSubscribeFunc<T>(){

            @Override
            public Subscription onSubscribe(Observer<? super T> observer) {
                return new Debounce(items, timeout, unit, scheduler).onSubscribe(observer);
            }
        };
    }

    private static class DebounceObserver<T>
    implements Observer<T> {
        private final Observer<? super T> observer;
        private final long timeout;
        private final TimeUnit unit;
        private final Scheduler scheduler;
        private final AtomicReference<Subscription> lastScheduledNotification = new AtomicReference();

        public DebounceObserver(Observer<? super T> observer, long timeout, TimeUnit unit, Scheduler scheduler) {
            this.observer = new SynchronizedObserver<T>(observer);
            this.timeout = timeout;
            this.unit = unit;
            this.scheduler = scheduler;
        }

        @Override
        public void onCompleted() {
            this.lastScheduledNotification.get().unsubscribe();
            this.observer.onCompleted();
        }

        @Override
        public void onError(Throwable e) {
            this.lastScheduledNotification.get().unsubscribe();
            this.observer.onError(e);
        }

        @Override
        public void onNext(final T v) {
            Subscription previousSubscription = this.lastScheduledNotification.getAndSet(this.scheduler.schedule(new Action0(){

                @Override
                public void call() {
                    DebounceObserver.this.observer.onNext(v);
                }
            }, this.timeout, this.unit));
            if (previousSubscription != null) {
                previousSubscription.unsubscribe();
            }
        }
    }

    private static class Debounce<T>
    implements Observable.OnSubscribeFunc<T> {
        private final Observable<T> items;
        private final long timeout;
        private final TimeUnit unit;
        private final Scheduler scheduler;

        public Debounce(Observable<T> items, long timeout, TimeUnit unit, Scheduler scheduler) {
            this.items = items;
            this.timeout = timeout;
            this.unit = unit;
            this.scheduler = scheduler;
        }

        @Override
        public Subscription onSubscribe(Observer<? super T> observer) {
            return this.items.subscribe(new DebounceObserver<T>(observer, this.timeout, this.unit, this.scheduler));
        }
    }
}

