/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.Observer;
import rx.Scheduler;
import rx.Subscription;
import rx.concurrency.Schedulers;
import rx.operators.ChunkedOperation;
import rx.util.Closing;
import rx.util.Opening;
import rx.util.functions.Func0;
import rx.util.functions.Func1;

public final class OperationWindow
extends ChunkedOperation {
    public static <T> Func0<Window<T>> windowMaker() {
        return new Func0<Window<T>>(){

            @Override
            public Window<T> call() {
                return new Window();
            }
        };
    }

    public static <T> Observable.OnSubscribeFunc<Observable<T>> window(final Observable<? extends T> source, final Func0<? extends Observable<? extends Closing>> windowClosingSelector) {
        return new Observable.OnSubscribeFunc<Observable<T>>(){

            @Override
            public Subscription onSubscribe(Observer<? super Observable<T>> observer) {
                ChunkedOperation.NonOverlappingChunks windows = new ChunkedOperation.NonOverlappingChunks(observer, OperationWindow.windowMaker());
                ChunkedOperation.ObservableBasedSingleChunkCreator creator = new ChunkedOperation.ObservableBasedSingleChunkCreator(windows, windowClosingSelector);
                return source.subscribe(new ChunkedOperation.ChunkObserver(windows, observer, creator));
            }
        };
    }

    public static <T> Observable.OnSubscribeFunc<Observable<T>> window(final Observable<? extends T> source, final Observable<? extends Opening> windowOpenings, final Func1<Opening, ? extends Observable<? extends Closing>> windowClosingSelector) {
        return new Observable.OnSubscribeFunc<Observable<T>>(){

            @Override
            public Subscription onSubscribe(Observer<? super Observable<T>> observer) {
                ChunkedOperation.OverlappingChunks windows = new ChunkedOperation.OverlappingChunks(observer, OperationWindow.windowMaker());
                ChunkedOperation.ObservableBasedMultiChunkCreator creator = new ChunkedOperation.ObservableBasedMultiChunkCreator(windows, windowOpenings, windowClosingSelector);
                return source.subscribe(new ChunkedOperation.ChunkObserver(windows, observer, creator));
            }
        };
    }

    public static <T> Observable.OnSubscribeFunc<Observable<T>> window(Observable<? extends T> source, int count) {
        return OperationWindow.window(source, count, count);
    }

    public static <T> Observable.OnSubscribeFunc<Observable<T>> window(final Observable<? extends T> source, final int count, final int skip) {
        return new Observable.OnSubscribeFunc<Observable<T>>(){

            @Override
            public Subscription onSubscribe(Observer<? super Observable<T>> observer) {
                ChunkedOperation.SizeBasedChunks chunks = new ChunkedOperation.SizeBasedChunks(observer, OperationWindow.windowMaker(), count);
                ChunkedOperation.SkippingChunkCreator creator = new ChunkedOperation.SkippingChunkCreator(chunks, skip);
                return source.subscribe(new ChunkedOperation.ChunkObserver(chunks, observer, creator));
            }
        };
    }

    public static <T> Observable.OnSubscribeFunc<Observable<T>> window(Observable<? extends T> source, long timespan, TimeUnit unit) {
        return OperationWindow.window(source, timespan, unit, Schedulers.threadPoolForComputation());
    }

    public static <T> Observable.OnSubscribeFunc<Observable<T>> window(final Observable<? extends T> source, final long timespan, final TimeUnit unit, final Scheduler scheduler) {
        return new Observable.OnSubscribeFunc<Observable<T>>(){

            @Override
            public Subscription onSubscribe(Observer<? super Observable<T>> observer) {
                ChunkedOperation.NonOverlappingChunks windows = new ChunkedOperation.NonOverlappingChunks(observer, OperationWindow.windowMaker());
                ChunkedOperation.TimeBasedChunkCreator creator = new ChunkedOperation.TimeBasedChunkCreator(windows, timespan, unit, scheduler);
                return source.subscribe(new ChunkedOperation.ChunkObserver(windows, observer, creator));
            }
        };
    }

    public static <T> Observable.OnSubscribeFunc<Observable<T>> window(Observable<? extends T> source, long timespan, TimeUnit unit, int count) {
        return OperationWindow.window(source, timespan, unit, count, Schedulers.threadPoolForComputation());
    }

    public static <T> Observable.OnSubscribeFunc<Observable<T>> window(final Observable<? extends T> source, final long timespan, final TimeUnit unit, final int count, final Scheduler scheduler) {
        return new Observable.OnSubscribeFunc<Observable<T>>(){

            @Override
            public Subscription onSubscribe(Observer<? super Observable<T>> observer) {
                ChunkedOperation.TimeAndSizeBasedChunks chunks = new ChunkedOperation.TimeAndSizeBasedChunks(observer, OperationWindow.windowMaker(), count, timespan, unit, scheduler);
                ChunkedOperation.SingleChunkCreator creator = new ChunkedOperation.SingleChunkCreator(chunks);
                return source.subscribe(new ChunkedOperation.ChunkObserver(chunks, observer, creator));
            }
        };
    }

    public static <T> Observable.OnSubscribeFunc<Observable<T>> window(Observable<? extends T> source, long timespan, long timeshift, TimeUnit unit) {
        return OperationWindow.window(source, timespan, timeshift, unit, Schedulers.threadPoolForComputation());
    }

    public static <T> Observable.OnSubscribeFunc<Observable<T>> window(final Observable<? extends T> source, final long timespan, final long timeshift, final TimeUnit unit, final Scheduler scheduler) {
        return new Observable.OnSubscribeFunc<Observable<T>>(){

            @Override
            public Subscription onSubscribe(Observer<? super Observable<T>> observer) {
                ChunkedOperation.TimeBasedChunks windows = new ChunkedOperation.TimeBasedChunks(observer, OperationWindow.windowMaker(), timespan, unit, scheduler);
                ChunkedOperation.TimeBasedChunkCreator creator = new ChunkedOperation.TimeBasedChunkCreator(windows, timeshift, unit, scheduler);
                return source.subscribe(new ChunkedOperation.ChunkObserver(windows, observer, creator));
            }
        };
    }

    protected static class Window<T>
    extends ChunkedOperation.Chunk<T, Observable<T>> {
        protected Window() {
        }

        @Override
        public Observable<T> getContents() {
            return Observable.from(this.contents);
        }
    }
}

