/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.groovy;

import java.io.File;
import java.io.FilenameFilter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.runners.MockitoJUnitRunner;

public class GroovyFileFilter
implements FilenameFilter {
    @Override
    public boolean accept(File dir, String name) {
        return name.endsWith(".groovy");
    }

    @RunWith(value=MockitoJUnitRunner.class)
    public static class UnitTest {
        @Mock
        private File nonGroovyFile;
        @Mock
        private File groovyFile;
        @Mock
        private File directory;

        @Before
        public void before() {
            MockitoAnnotations.initMocks((Object)this);
        }

        @Test
        public void testGroovyFileFilter() {
            Mockito.when((Object)this.nonGroovyFile.getName()).thenReturn((Object)"file.mikey");
            Mockito.when((Object)this.groovyFile.getName()).thenReturn((Object)"file.groovy");
            GroovyFileFilter filter = new GroovyFileFilter();
            Assert.assertFalse((boolean)filter.accept(this.nonGroovyFile, "file.mikey"));
            Assert.assertTrue((boolean)filter.accept(this.groovyFile, "file.groovy"));
        }
    }
}

