/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.networknt.schema.ApplyDefaultsStrategy;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.I18nSupport;
import com.networknt.schema.PathType;
import com.networknt.schema.uri.URITranslator;
import com.networknt.schema.walk.JsonSchemaWalkListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.function.Supplier;

public class SchemaValidatorsConfig {
    private boolean typeLoose;
    private boolean failFast;
    private ApplyDefaultsStrategy applyDefaultsStrategy;
    private boolean ecma262Validator;
    private boolean javaSemantics;
    private boolean losslessNarrowing;
    private boolean isCustomMessageSupported = true;
    private boolean openAPI3StyleDiscriminators = false;
    private final Map<String, Boolean> strictness = new HashMap<String, Boolean>(0);
    private Map<String, String> uriMappings = new HashMap<String, String>();
    private URITranslator.CompositeURITranslator uriTranslators = new URITranslator.CompositeURITranslator();
    private boolean handleNullableField = true;
    private Boolean readOnly = null;
    private Boolean writeOnly = null;
    private PathType pathType = PathType.DEFAULT;
    public static final String ALL_KEYWORD_WALK_LISTENER_KEY = "com.networknt.AllKeywordWalkListener";
    private final Map<String, List<JsonSchemaWalkListener>> keywordWalkListenersMap = new HashMap<String, List<JsonSchemaWalkListener>>();
    private final List<JsonSchemaWalkListener> propertyWalkListeners = new ArrayList<JsonSchemaWalkListener>();
    private final List<JsonSchemaWalkListener> itemWalkListeners = new ArrayList<JsonSchemaWalkListener>();
    private Supplier<ExecutionContext> executionContextSupplier;
    private boolean loadCollectors = true;
    private Locale locale;
    private ResourceBundle resourceBundle;
    private ResourceBundle resourceBundleToUse;
    private boolean disableUnevaluatedItems = false;
    private boolean disableUnevaluatedProperties = false;

    public SchemaValidatorsConfig disableUnevaluatedAnalysis() {
        this.disableUnevaluatedItems();
        this.disableUnevaluatedProperties();
        return this;
    }

    public SchemaValidatorsConfig disableUnevaluatedItems() {
        this.disableUnevaluatedItems = true;
        return this;
    }

    public SchemaValidatorsConfig disableUnevaluatedProperties() {
        this.disableUnevaluatedProperties = true;
        return this;
    }

    public SchemaValidatorsConfig enableUnevaluatedAnalysis() {
        this.enableUnevaluatedItems();
        this.enableUnevaluatedProperties();
        return this;
    }

    public SchemaValidatorsConfig enableUnevaluatedItems() {
        this.disableUnevaluatedItems = false;
        return this;
    }

    public SchemaValidatorsConfig enableUnevaluatedProperties() {
        this.disableUnevaluatedProperties = false;
        return this;
    }

    public boolean isUnevaluatedItemsAnalysisDisabled() {
        return this.disableUnevaluatedItems;
    }

    public boolean isUnevaluatedItemsAnalysisEnabled() {
        return !this.isUnevaluatedItemsAnalysisDisabled();
    }

    public boolean isUnevaluatedPropertiesAnalysisDisabled() {
        return this.disableUnevaluatedProperties;
    }

    public boolean isUnevaluatedPropertiesAnalysisEnabled() {
        return !this.isUnevaluatedPropertiesAnalysisDisabled();
    }

    public boolean isTypeLoose() {
        return this.typeLoose;
    }

    public void setTypeLoose(boolean typeLoose) {
        this.typeLoose = typeLoose;
    }

    public void setFailFast(boolean failFast) {
        this.failFast = failFast;
    }

    public boolean isFailFast() {
        return this.failFast;
    }

    public void setApplyDefaultsStrategy(ApplyDefaultsStrategy applyDefaultsStrategy) {
        this.applyDefaultsStrategy = applyDefaultsStrategy;
    }

    public ApplyDefaultsStrategy getApplyDefaultsStrategy() {
        return this.applyDefaultsStrategy;
    }

    public URITranslator.CompositeURITranslator getUriTranslator() {
        return this.uriTranslators.with(URITranslator.map(this.uriMappings));
    }

    public void addUriTranslator(URITranslator uriTranslator) {
        if (null != uriTranslator) {
            this.uriTranslators.add(uriTranslator);
        }
    }

    @Deprecated
    public Map<String, String> getUriMappings() {
        return new HashMap<String, String>(this.uriMappings);
    }

    @Deprecated
    public void setUriMappings(Map<String, String> uriMappings) {
        this.uriMappings = uriMappings;
    }

    public boolean isHandleNullableField() {
        return this.handleNullableField;
    }

    public void setHandleNullableField(boolean handleNullableField) {
        this.handleNullableField = handleNullableField;
    }

    public boolean isEcma262Validator() {
        return this.ecma262Validator;
    }

    public void setEcma262Validator(boolean ecma262Validator) {
        this.ecma262Validator = ecma262Validator;
    }

    public boolean isJavaSemantics() {
        return this.javaSemantics;
    }

    public void setJavaSemantics(boolean javaSemantics) {
        this.javaSemantics = javaSemantics;
    }

    public boolean isCustomMessageSupported() {
        return this.isCustomMessageSupported;
    }

    public void setCustomMessageSupported(boolean customMessageSupported) {
        this.isCustomMessageSupported = customMessageSupported;
    }

    public void addKeywordWalkListener(JsonSchemaWalkListener keywordWalkListener) {
        if (this.keywordWalkListenersMap.get(ALL_KEYWORD_WALK_LISTENER_KEY) == null) {
            ArrayList keywordWalkListeners = new ArrayList();
            this.keywordWalkListenersMap.put(ALL_KEYWORD_WALK_LISTENER_KEY, keywordWalkListeners);
        }
        this.keywordWalkListenersMap.get(ALL_KEYWORD_WALK_LISTENER_KEY).add(keywordWalkListener);
    }

    public void addKeywordWalkListener(String keyword, JsonSchemaWalkListener keywordWalkListener) {
        if (this.keywordWalkListenersMap.get(keyword) == null) {
            ArrayList keywordWalkListeners = new ArrayList();
            this.keywordWalkListenersMap.put(keyword, keywordWalkListeners);
        }
        this.keywordWalkListenersMap.get(keyword).add(keywordWalkListener);
    }

    public void addKeywordWalkListeners(List<JsonSchemaWalkListener> keywordWalkListeners) {
        if (this.keywordWalkListenersMap.get(ALL_KEYWORD_WALK_LISTENER_KEY) == null) {
            ArrayList ikeywordWalkListeners = new ArrayList();
            this.keywordWalkListenersMap.put(ALL_KEYWORD_WALK_LISTENER_KEY, ikeywordWalkListeners);
        }
        this.keywordWalkListenersMap.get(ALL_KEYWORD_WALK_LISTENER_KEY).addAll(keywordWalkListeners);
    }

    public void addKeywordWalkListeners(String keyword, List<JsonSchemaWalkListener> keywordWalkListeners) {
        if (this.keywordWalkListenersMap.get(keyword) == null) {
            ArrayList ikeywordWalkListeners = new ArrayList();
            this.keywordWalkListenersMap.put(keyword, ikeywordWalkListeners);
        }
        this.keywordWalkListenersMap.get(keyword).addAll(keywordWalkListeners);
    }

    public void addPropertyWalkListeners(List<JsonSchemaWalkListener> propertyWalkListeners) {
        this.propertyWalkListeners.addAll(propertyWalkListeners);
    }

    public void addPropertyWalkListener(JsonSchemaWalkListener propertyWalkListener) {
        this.propertyWalkListeners.add(propertyWalkListener);
    }

    public void addItemWalkListener(JsonSchemaWalkListener itemWalkListener) {
        this.itemWalkListeners.add(itemWalkListener);
    }

    public void addItemWalkListeners(List<JsonSchemaWalkListener> itemWalkListeners) {
        this.itemWalkListeners.addAll(itemWalkListeners);
    }

    public List<JsonSchemaWalkListener> getPropertyWalkListeners() {
        return this.propertyWalkListeners;
    }

    public Map<String, List<JsonSchemaWalkListener>> getKeywordWalkListenersMap() {
        return this.keywordWalkListenersMap;
    }

    public List<JsonSchemaWalkListener> getArrayItemWalkListeners() {
        return this.itemWalkListeners;
    }

    public Supplier<ExecutionContext> getExecutionContextSupplier() {
        return this.executionContextSupplier;
    }

    public void setExecutionContextSupplier(Supplier<ExecutionContext> executionContextSupplier) {
        this.executionContextSupplier = executionContextSupplier;
    }

    public boolean isLosslessNarrowing() {
        return this.losslessNarrowing;
    }

    public void setLosslessNarrowing(boolean losslessNarrowing) {
        this.losslessNarrowing = losslessNarrowing;
    }

    public boolean isOpenAPI3StyleDiscriminators() {
        return this.openAPI3StyleDiscriminators;
    }

    public void setOpenAPI3StyleDiscriminators(boolean openAPI3StyleDiscriminators) {
        this.openAPI3StyleDiscriminators = openAPI3StyleDiscriminators;
    }

    public void setLoadCollectors(boolean loadCollectors) {
        this.loadCollectors = loadCollectors;
    }

    public boolean doLoadCollectors() {
        return this.loadCollectors;
    }

    public boolean isReadOnly() {
        return null != this.readOnly && this.readOnly != false;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isWriteOnly() {
        return null != this.writeOnly && this.writeOnly != false;
    }

    public void setWriteOnly(boolean writeOnly) {
        this.writeOnly = writeOnly;
    }

    @Deprecated
    public boolean isWriteMode() {
        return null == this.writeOnly || this.writeOnly != false;
    }

    @Deprecated
    public void setWriteMode(boolean writeMode) {
        if (writeMode) {
            this.setWriteOnly(true);
        } else {
            this.setReadOnly(true);
        }
    }

    public void setPathType(PathType pathType) {
        this.pathType = pathType;
    }

    public PathType getPathType() {
        return this.pathType;
    }

    public boolean isStrict(String keyword) {
        return this.strictness.getOrDefault(Objects.requireNonNull(keyword, "keyword cannot be null"), Boolean.TRUE);
    }

    public void setStrict(String keyword, boolean strict) {
        this.strictness.put(Objects.requireNonNull(keyword, "keyword cannot be null"), strict);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        if (this.locale == null || this.resourceBundleToUse != null && !this.locale.equals(this.resourceBundleToUse.getLocale())) {
            this.resourceBundleToUse = null;
        }
    }

    public ResourceBundle getResourceBundle() {
        if (this.resourceBundleToUse == null) {
            this.resourceBundleToUse = this.resourceBundle;
            if (this.resourceBundleToUse == null) {
                this.resourceBundleToUse = this.locale == null ? I18nSupport.DEFAULT_RESOURCE_BUNDLE : ResourceBundle.getBundle("jsv-messages", this.locale);
            }
        }
        return this.resourceBundleToUse;
    }

    public void setResourceBundle(ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
        if (this.resourceBundle == null || !this.resourceBundle.equals(this.resourceBundleToUse)) {
            this.resourceBundleToUse = null;
        }
    }
}

