/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.JsonNodePath;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.Keyword;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.annotation.JsonNodeAnnotation;
import java.util.function.Consumer;

public abstract class AbstractJsonValidator
implements JsonValidator {
    private final SchemaLocation schemaLocation;
    private final JsonNode schemaNode;
    private final JsonNodePath evaluationPath;
    private final Keyword keyword;

    public AbstractJsonValidator(SchemaLocation schemaLocation, JsonNodePath evaluationPath, Keyword keyword, JsonNode schemaNode) {
        this.schemaLocation = schemaLocation;
        this.evaluationPath = evaluationPath;
        this.keyword = keyword;
        this.schemaNode = schemaNode;
    }

    @Override
    public SchemaLocation getSchemaLocation() {
        return this.schemaLocation;
    }

    @Override
    public JsonNodePath getEvaluationPath() {
        return this.evaluationPath;
    }

    @Override
    public String getKeyword() {
        return this.keyword.getValue();
    }

    public JsonNode getSchemaNode() {
        return this.schemaNode;
    }

    public String toString() {
        return this.getEvaluationPath().getName(-1);
    }

    protected boolean collectAnnotations(ExecutionContext executionContext) {
        return this.collectAnnotations(executionContext, this.getKeyword());
    }

    protected boolean collectAnnotations(ExecutionContext executionContext, String keyword) {
        return executionContext.getExecutionConfig().isAnnotationCollectionEnabled() && executionContext.getExecutionConfig().getAnnotationCollectionFilter().test(keyword);
    }

    protected void putAnnotation(ExecutionContext executionContext, Consumer<JsonNodeAnnotation.Builder> customizer) {
        JsonNodeAnnotation.Builder builder = JsonNodeAnnotation.builder().evaluationPath(this.evaluationPath).schemaLocation(this.schemaLocation).keyword(this.getKeyword());
        customizer.accept(builder);
        executionContext.getAnnotations().put(builder.build());
    }
}

