/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.walk;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.JsonNodePath;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.walk.AbstractWalkListenerRunner;
import com.networknt.schema.walk.JsonSchemaWalkListener;
import com.networknt.schema.walk.WalkEvent;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefaultKeywordWalkListenerRunner
extends AbstractWalkListenerRunner {
    private final Map<String, List<JsonSchemaWalkListener>> keywordWalkListenersMap;

    public DefaultKeywordWalkListenerRunner(Map<String, List<JsonSchemaWalkListener>> keywordWalkListenersMap) {
        this.keywordWalkListenersMap = keywordWalkListenersMap;
    }

    @Override
    public boolean runPreWalkListeners(ExecutionContext executionContext, String keyword, JsonNode instanceNode, JsonNode rootNode, JsonNodePath instanceLocation, JsonSchema schema, JsonValidator validator) {
        boolean continueRunningListenersAndWalk = true;
        WalkEvent keywordWalkEvent = this.constructWalkEvent(executionContext, keyword, instanceNode, rootNode, instanceLocation, schema, validator);
        List<JsonSchemaWalkListener> currentKeywordListeners = this.keywordWalkListenersMap.get(keyword);
        continueRunningListenersAndWalk = this.runPreWalkListeners(currentKeywordListeners, keywordWalkEvent);
        if (continueRunningListenersAndWalk) {
            List<JsonSchemaWalkListener> allKeywordListeners = this.keywordWalkListenersMap.get("com.networknt.AllKeywordWalkListener");
            this.runPreWalkListeners(allKeywordListeners, keywordWalkEvent);
        }
        return continueRunningListenersAndWalk;
    }

    @Override
    public void runPostWalkListeners(ExecutionContext executionContext, String keyword, JsonNode instanceNode, JsonNode rootNode, JsonNodePath instanceLocation, JsonSchema schema, JsonValidator validator, Set<ValidationMessage> validationMessages) {
        WalkEvent keywordWalkEvent = this.constructWalkEvent(executionContext, keyword, instanceNode, rootNode, instanceLocation, schema, validator);
        List<JsonSchemaWalkListener> currentKeywordListeners = this.keywordWalkListenersMap.get(keyword);
        this.runPostWalkListeners(currentKeywordListeners, keywordWalkEvent, validationMessages);
        List<JsonSchemaWalkListener> allKeywordListeners = this.keywordWalkListenersMap.get("com.networknt.AllKeywordWalkListener");
        this.runPostWalkListeners(allKeywordListeners, keywordWalkEvent, validationMessages);
    }
}

