/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.AgentCommandLineParser;
import com.newrelic.agent.IAgent;
import com.newrelic.agent.InstrumentationProxy;
import com.newrelic.agent.PrivateApiImpl;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.ConfigService;
import com.newrelic.agent.install.ConfigInstaller;
import com.newrelic.agent.logging.AgentLogManager;
import com.newrelic.agent.logging.IAgentLogger;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.service.ServiceManagerImpl;
import com.newrelic.api.agent.NewRelicApiImplementation;
import com.newrelic.bootstrap.BootstrapAgent;
import java.lang.instrument.Instrumentation;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Level;

public final class Agent
extends AbstractService
implements IAgent {
    public static final IAgentLogger LOG = AgentLogManager.getLogger();
    public static final int ASM_LEVEL = 327680;
    private static final String AGENT_ENABLED_PROPERTY = "newrelic.config.agent_enabled";
    private static final boolean DEBUG = Boolean.getBoolean("newrelic.debug");
    private static final String VERSION = Agent.initVersion();
    private static final ClassLoader NR_CLASS_LOADER = BootstrapAgent.class.getClassLoader() == null ? ClassLoader.getSystemClassLoader() : BootstrapAgent.class.getClassLoader();
    private volatile boolean enabled = true;
    private final Instrumentation instrumentation;
    private volatile InstrumentationProxy instrumentationProxy;

    private Agent(Instrumentation instrumentation) {
        super(IAgent.class.getSimpleName());
        this.instrumentation = instrumentation;
    }

    protected void doStart() {
        ConfigService configService = ServiceFactory.getConfigService();
        AgentConfig config = configService.getDefaultAgentConfig();
        AgentLogManager.configureLogger(config);
        this.logHostIp();
        LOG.info(MessageFormat.format("New Relic Agent v{0} is initializing...", Agent.getVersion()));
        this.enabled = config.isAgentEnabled();
        if (!this.enabled) {
            LOG.info("New Relic agent is disabled.");
        }
        this.instrumentationProxy = InstrumentationProxy.getInstrumentationProxy(this.instrumentation);
        this.initializeBridgeApis();
        final long startTime = System.currentTimeMillis();
        Runnable runnable = new Runnable(){

            public void run() {
                Agent.this.jvmShutdown(startTime);
            }
        };
        Thread shutdownThread = new Thread(runnable, "New Relic JVM Shutdown");
        Runtime.getRuntime().addShutdownHook(shutdownThread);
    }

    private void initializeBridgeApis() {
        NewRelicApiImplementation.initialize();
        PrivateApiImpl.initialize(LOG);
    }

    private void logHostIp() {
        try {
            InetAddress address = InetAddress.getLocalHost();
            LOG.info("Agent Host: " + address.getHostName() + " IP: " + address.getHostAddress());
        }
        catch (UnknownHostException e) {
            LOG.info("New Relic could not identify host/ip.");
        }
    }

    protected void doStop() {
    }

    public void shutdownAsync() {
        Runnable runnable = new Runnable(){

            public void run() {
                Agent.this.shutdown();
            }
        };
        Thread shutdownThread = new Thread(runnable, "New Relic Shutdown");
        shutdownThread.start();
    }

    private void jvmShutdown(long startTime) {
        AgentConfig config = ServiceFactory.getConfigService().getDefaultAgentConfig();
        if (config.isSendDataOnExit() && System.currentTimeMillis() - startTime >= config.getSendDataOnExitThresholdInMillis()) {
            ServiceFactory.getHarvestService().harvestNow();
        }
        this.getLogger().info("JVM is shutting down");
        this.shutdown();
    }

    public synchronized void shutdown() {
        try {
            ServiceFactory.getServiceManager().stop();
            this.getLogger().info("New Relic Agent has shutdown");
        }
        catch (Exception e) {
            LOG.severe(MessageFormat.format("Error shutting down New Relic Agent: {0}", e));
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public InstrumentationProxy getInstrumentation() {
        return this.instrumentationProxy;
    }

    public static String getVersion() {
        return VERSION;
    }

    public static ClassLoader getClassLoader() {
        return NR_CLASS_LOADER;
    }

    private static String initVersion() {
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(Agent.class.getName());
            return bundle.getString("version");
        }
        catch (Throwable throwable) {
            return "0.0";
        }
    }

    public static boolean isDebugEnabled() {
        return DEBUG;
    }

    public static void premain(String agentArgs, Instrumentation inst) {
        if (ServiceFactory.getServiceManager() != null) {
            LOG.warning("New Relic Agent is already running! Check if more than one -javaagent switch is used on the command line.");
            return;
        }
        String enabled = System.getProperty(AGENT_ENABLED_PROPERTY);
        if (enabled != null && !Boolean.parseBoolean(enabled.toString())) {
            LOG.warning("New Relic agent is disabled by a system property.");
            return;
        }
        String jvmName = System.getProperty("java.vm.name");
        if (jvmName.contains("Oracle JRockit")) {
            String msg = MessageFormat.format("New Relic agent {0} does not support the Oracle JRockit JVM. Please use a 2.21.x or earlier version of the agent. JVM  is: {1}.", Agent.getVersion(), jvmName);
            LOG.error(msg);
        }
        try {
            Agent agent = new Agent(inst);
            ServiceManagerImpl serviceManager = new ServiceManagerImpl(agent);
            ServiceFactory.setServiceManager(serviceManager);
            if (ConfigInstaller.isLicenseKeyEmpty(serviceManager.getConfigService().getDefaultAgentConfig().getLicenseKey())) {
                LOG.error("license_key is empty in the config. Not starting New Relic Agent.");
                return;
            }
            if (!serviceManager.getConfigService().getDefaultAgentConfig().isAgentEnabled()) {
                LOG.warning("agent_enabled is false in the config. Not starting New Relic Agent.");
                return;
            }
            serviceManager.start();
            LOG.info(MessageFormat.format("New Relic Agent v{0} has started", Agent.getVersion()));
            if (BootstrapAgent.isBootstrapClasspathFlagSet()) {
                LOG.info("The newrelic.bootstrap_classpath system property is deprecated.");
            }
            if (Agent.class.getClassLoader() == null) {
                LOG.info("Agent class loader is null which typically means the agent is loaded by the bootstrap class loader.");
            } else {
                LOG.info("Agent class loader: " + Agent.class.getClassLoader());
            }
        }
        catch (Throwable t) {
            String msg = MessageFormat.format("Unable to start New Relic agent: {0}", t);
            try {
                LOG.log(Level.SEVERE, msg, t);
            }
            catch (Throwable t2) {
                // empty catch block
            }
            System.err.println(msg);
            t.printStackTrace();
        }
    }

    public static void main(String[] args) {
        String javaVersion = System.getProperty("java.version");
        if (javaVersion.startsWith("1.5")) {
            String msg = MessageFormat.format("Java version is: {0}.  This version of the New Relic Agent does not support Java 1.5.  Please use a 2.21.x or earlier version.", javaVersion);
            System.err.println("----------");
            System.err.println(msg);
            System.err.println("----------");
            return;
        }
        new AgentCommandLineParser().parseCommand(args);
    }
}

