/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.deps.com.google.common.collect.MapMaker;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyMapImpl<K, V>
implements Map<K, V> {
    private Map<K, V> parameters;
    private final MapMaker factory;

    public LazyMapImpl() {
        this(5);
    }

    public LazyMapImpl(int initialSize) {
        this(new MapMaker().initialCapacity(initialSize).concurrencyLevel(1));
    }

    public LazyMapImpl(MapMaker factory) {
        this.factory = factory;
    }

    private Map<K, V> getParameters() {
        if (this.parameters == null) {
            this.parameters = this.factory.makeMap();
        }
        return this.parameters;
    }

    @Override
    public V put(K key, V value) {
        return this.getParameters().put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> params) {
        if (params != null && !params.isEmpty()) {
            this.getParameters().putAll(params);
        }
    }

    @Override
    public V remove(Object key) {
        if (this.parameters == null) {
            return null;
        }
        return this.getParameters().remove(key);
    }

    @Override
    public V get(Object key) {
        if (this.parameters == null) {
            return null;
        }
        return this.getParameters().get(key);
    }

    @Override
    public void clear() {
        if (this.parameters != null) {
            this.parameters.clear();
        }
    }

    @Override
    public int size() {
        if (this.parameters == null) {
            return 0;
        }
        return this.getParameters().size();
    }

    @Override
    public boolean isEmpty() {
        if (this.parameters == null) {
            return true;
        }
        return this.getParameters().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.parameters == null) {
            return false;
        }
        return this.getParameters().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        if (this.parameters == null) {
            return false;
        }
        return this.getParameters().containsValue(value);
    }

    @Override
    public Set<K> keySet() {
        return this.getParameters().keySet();
    }

    @Override
    public Collection<V> values() {
        return this.getParameters().values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.getParameters().entrySet();
    }
}

