/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.AgentImpl;
import com.newrelic.agent.AsyncApiImpl;
import com.newrelic.agent.attributes.AgentAttributeSender;
import com.newrelic.agent.attributes.AttributeSender;
import com.newrelic.agent.bridge.AgentBridge;
import com.newrelic.agent.bridge.PrivateApi;
import com.newrelic.agent.environment.Environment;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.websphere.WebSphereApiImpl;
import com.newrelic.api.agent.Logger;
import java.io.Closeable;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;

public class PrivateApiImpl
implements PrivateApi {
    private final AttributeSender attributeSender = new AgentAttributeSender();

    public static void initialize(Logger logger) {
        PrivateApiImpl api = new PrivateApiImpl();
        AgentBridge.privateApi = api;
        AgentBridge.asyncApi = new AsyncApiImpl(logger);
        AgentBridge.websphereApi = new WebSphereApiImpl();
        AgentBridge.agent = new AgentImpl(logger);
    }

    public void setAppServerPort(int port) {
        ServiceFactory.getEnvironmentService().getEnvironment().setServerPort(port);
    }

    public void setInstanceName(String instanceName) {
        ServiceFactory.getEnvironmentService().getEnvironment().setInstanceName(instanceName);
    }

    public Closeable addSampler(Runnable sampler, int period, TimeUnit timeUnit) {
        return ServiceFactory.getSamplerService().addSampler(sampler, period, timeUnit);
    }

    public void setServerInfo(String dispatcherName, String version) {
        ServiceFactory.getEnvironmentService().getEnvironment().setServerInfo(dispatcherName, version);
    }

    public void setServerInfo(String serverInfo) {
        Environment env = ServiceFactory.getEnvironmentService().getEnvironment();
        if (!env.getAgentIdentity().isServerInfoSet()) {
            env.setServerInfo(serverInfo);
        }
    }

    public void addMBeanServer(MBeanServer server) {
        ServiceFactory.getJmxService().setJmxServer(server);
    }

    public void removeMBeanServer(MBeanServer serverToRemove) {
        ServiceFactory.getJmxService().removeJmxServer(serverToRemove);
    }

    public void addCustomAttribute(String key, String value) {
        this.attributeSender.addAttribute(key, value);
    }

    public void addCustomAttribute(String key, Number value) {
        this.attributeSender.addAttribute(key, value);
    }
}

