/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.Transaction;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.TransactionTracerConfig;
import com.newrelic.agent.dispatchers.Dispatcher;
import com.newrelic.agent.sql.SqlTracerListener;
import com.newrelic.agent.stats.ApdexPerfZone;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.transaction.PriorityTransactionName;
import com.newrelic.agent.transaction.TransactionTimer;
import java.util.Collection;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionData {
    private final Transaction tx;
    private final int transactionSize;
    private final boolean forcePersist;
    private final long threadId;

    public TransactionData(Transaction transaction, int transactionSize, boolean forcePersist) {
        this.tx = transaction;
        this.transactionSize = transactionSize;
        this.forcePersist = forcePersist;
        this.threadId = Thread.currentThread().getId();
    }

    public Dispatcher getDispatcher() {
        return this.tx.getDispatcher();
    }

    public TransactionTimer getTransactionTime() {
        return this.tx.getTransactionTimer();
    }

    public Tracer getRootTracer() {
        return this.tx.getRootTracer();
    }

    public Collection<Tracer> getTracers() {
        return this.tx.getAllTracers();
    }

    public long getWallClockStartTimeMs() {
        return this.tx.getWallClockStartTimeMs();
    }

    public long getStartTimeInNanos() {
        return this.tx.getTransactionTimer().getStartTime();
    }

    public long getEndTimeInNanos() {
        return this.tx.getTransactionTimer().getEndTime();
    }

    public String getRequestUri() {
        return this.getDispatcher().getUri();
    }

    public int getResponseStatus() {
        return this.tx.getStatus();
    }

    public String getStatusMessage() {
        return this.tx.getStatusMessage();
    }

    public final long getThreadId() {
        return this.threadId;
    }

    public String getApplicationName() {
        return this.tx.getRPMService().getApplicationName();
    }

    public AgentConfig getAgentConfig() {
        return this.tx.getAgentConfig();
    }

    public TransactionTracerConfig getTransactionTracerConfig() {
        return this.getAgentConfig() == null ? null : this.getAgentConfig().getTransactionTracerConfig();
    }

    public Map<String, Object> getInternalParameters() {
        return this.tx.getInternalParameters();
    }

    public Map<String, Map<String, String>> getPrefixedAttributes() {
        return this.tx.getPrefixedAgentAttributes();
    }

    public Map<String, Object> getUserAttributes() {
        return this.tx.getUserAttributes();
    }

    public Map<String, Object> getAgentAttributes() {
        return this.tx.getAgentAttributes();
    }

    public Map<String, String> getErrorAttributes() {
        return this.tx.getErrorAttributes();
    }

    public Map<String, Object> getIntrinsicAttributes() {
        return this.tx.getIntrinsicAttributes();
    }

    public PriorityTransactionName getPriorityTransactionName() {
        return this.tx.getPriorityTransactionName();
    }

    public String getBlameMetricName() {
        return this.getPriorityTransactionName().getName();
    }

    public String getBlameOrRootMetricName() {
        return this.getBlameMetricName() == null ? this.getRootTracer().getMetricName() : this.getBlameMetricName();
    }

    public Throwable getThrowable() {
        return this.tx.getReportError();
    }

    protected final int getTransactionSize() {
        return this.transactionSize;
    }

    public long getDurationInMillis() {
        return this.tx.getTransactionTimer().getResponseTimeInMilliseconds();
    }

    public long getDuration() {
        return this.tx.getTransactionTimer().getResponseTime();
    }

    public String getGuid() {
        return this.tx.getCrossProcessTransactionState().getGuid();
    }

    public String getReferrerGuid() {
        return this.tx.getCrossProcessTransactionState().getReferrerGuid();
    }

    public String getTripId() {
        return this.tx.getCrossProcessTransactionState().getTripId();
    }

    public int generatePathHash() {
        return this.tx.getCrossProcessTransactionState().generatePathHash();
    }

    public Integer getReferringPathHash() {
        return this.tx.getCrossProcessTransactionState().getReferringPathHash();
    }

    public String getAlternatePathHashes() {
        return this.tx.getCrossProcessTransactionState().getAlternatePathHashes();
    }

    public ApdexPerfZone getApdexPerfZone() {
        if (!this.isWebTransaction() && !this.tx.getAgentConfig().isApdexTSet(this.getPriorityTransactionName().getName())) {
            return null;
        }
        long responseTimeInMillis = this.tx.getTransactionTimer().getResponseTimeInMilliseconds() + this.tx.getExternalTime();
        long apdexTInMillis = this.tx.getAgentConfig().getApdexTInMillis(this.getPriorityTransactionName().getName());
        return ApdexPerfZone.getZone(responseTimeInMillis, apdexTInMillis);
    }

    public boolean getForcePersist() {
        return this.forcePersist;
    }

    public boolean isWebTransaction() {
        return this.getDispatcher().isWebTransaction();
    }

    public SqlTracerListener getSqlTracerListener() {
        return this.tx.getSqlTracerListener();
    }

    public String toString() {
        String name = this.getRequestUri() == null ? this.getRootTracer().getMetricName() : this.getRequestUri();
        StringBuilder builder = new StringBuilder(name == null ? "" : name).append(' ').append(this.getDurationInMillis()).append("ms");
        if (this.getThrowable() != null) {
            builder.append(' ').append(this.getThrowable().toString());
        }
        return builder.toString();
    }
}

