/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.async;

import com.newrelic.agent.Agent;
import com.newrelic.agent.TransactionActivity;
import com.newrelic.agent.config.TransactionTracerConfig;
import com.newrelic.agent.database.SqlObfuscator;
import com.newrelic.agent.stats.ResponseTimeStats;
import com.newrelic.agent.stats.TransactionStats;
import com.newrelic.agent.trace.TransactionSegment;
import com.newrelic.agent.tracers.AbstractTracer;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.SkipTracer;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.tracers.metricname.MetricNameFormat;
import com.newrelic.agent.tracers.metricname.SimpleMetricNameFormat;
import com.newrelic.agent.util.Strings;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncTracer
extends AbstractTracer {
    private static final int INITIAL_PARAMETER_MAP_SIZE = 5;
    private final long startTime;
    private final long duration;
    private Map<String, Object> parameters;
    private volatile Tracer parentTracer;
    private final ClassMethodSignature classMethodSignature;
    private MetricNameFormat metricNameFormat;
    protected final boolean generateTransactionSegment;
    private final boolean metricProducer;
    private boolean isParent;

    public AsyncTracer(TransactionActivity txa, ClassMethodSignature sig, MetricNameFormat metricNameFormatter, long startTime, long endTime) {
        super(txa.getTransaction(), txa);
        this.startTime = startTime;
        this.metricNameFormat = metricNameFormatter;
        this.classMethodSignature = sig;
        this.parentTracer = txa.getLastTracer();
        this.generateTransactionSegment = txa.getTransaction().shouldGenerateTransactionSegment();
        this.metricProducer = true;
        this.duration = Math.max(0L, endTime - startTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void finish(Throwable throwable) {
        TransactionActivity activity = this.getTransaction().getTransactionActivity();
        try {
            try {
                activity.lockTracerStart();
                this.doFinish(throwable);
            }
            catch (Throwable t) {
                String msg = MessageFormat.format("An error occurred finishing tracer for class {0} : {1}", this.classMethodSignature.getClassName(), t);
                if (Agent.LOG.isLoggable(Level.FINER)) {
                    Agent.LOG.log(Level.WARNING, msg, t);
                } else {
                    Agent.LOG.warning(msg);
                }
                Object var6_4 = null;
                activity.unlockTracerStart();
            }
            Object var6_3 = null;
            activity.unlockTracerStart();
        }
        catch (Throwable throwable2) {
            Object var6_5 = null;
            activity.unlockTracerStart();
            throw throwable2;
        }
        this.finish(191, null);
        if (Agent.isDebugEnabled()) {
            Agent.LOG.log(Level.FINE, "(Debug) Tracer.finish(Throwable)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish(int opcode, Object returnValue) {
        String msg;
        TransactionActivity activity = this.getTransaction().getTransactionActivity();
        try {
            block10: {
                try {
                    activity.lockTracerStart();
                    if (191 == opcode) break block10;
                    this.doFinish(opcode, returnValue);
                }
                catch (Throwable t) {
                    msg = MessageFormat.format("An error occurred finishing tracer for class {0} : {1}", this.classMethodSignature.getClassName(), t.toString());
                    Agent.LOG.severe(msg);
                    Agent.LOG.log(Level.FINER, msg, t);
                    Object var7_5 = null;
                    activity.unlockTracerStart();
                }
            }
            Object var7_4 = null;
            activity.unlockTracerStart();
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            activity.unlockTracerStart();
            throw throwable;
        }
        if (this.parentTracer != null) {
            this.parentTracer.childTracerFinished(this);
        }
        try {
            this.recordMetrics(this.getTransaction().getTransactionActivity().getTransactionStats());
        }
        catch (Throwable t) {
            msg = MessageFormat.format("An error occurred recording tracer metrics for class {0} : {1}", this.classMethodSignature.getClassName(), t.toString());
            Agent.LOG.severe(msg);
            Agent.LOG.log(Level.FINER, msg, t);
        }
        try {
            if (!(this instanceof SkipTracer)) {
                activity.tracerFinished(this, opcode);
            }
        }
        catch (Throwable t) {
            msg = MessageFormat.format("An error occurred calling Transaction.tracerFinished() for class {0} : {1}", this.classMethodSignature.getClassName(), t.toString());
            Agent.LOG.severe(msg);
            Agent.LOG.log(Level.FINER, msg, t);
        }
    }

    protected void doFinish(Throwable throwable) {
    }

    protected void doFinish(int opcode, Object returnValue) {
    }

    public void put(String key, Object value) {
        if (this.parameters == null) {
            if (this.getTransaction().getTransactionCounts().isOverTracerSegmentLimit()) {
                return;
            }
            this.parameters = new HashMap<String, Object>(1, 5.0f);
        }
        if (value.getClass().isArray()) {
            value = Arrays.asList((Object[])value);
        }
        this.getTransaction().getTransactionCounts().incrementSize(AsyncTracer.sizeof(value));
        this.parameters.put(key, value);
    }

    static int sizeof(Object value) {
        int size = 0;
        if (value == null) {
            return 0;
        }
        if (value instanceof String) {
            return ((String)value).length();
        }
        if (value instanceof StackTraceElement) {
            StackTraceElement elem = (StackTraceElement)value;
            return AsyncTracer.sizeof(elem.getClassName()) + AsyncTracer.sizeof(elem.getFileName()) + AsyncTracer.sizeof(elem.getMethodName()) + 10;
        }
        if (value instanceof Object[]) {
            for (Object obj : (Object[])value) {
                size += AsyncTracer.sizeof(obj);
            }
        }
        return size;
    }

    @Override
    public Map<String, Object> getParameters() {
        if (this.parameters == null) {
            return Collections.emptyMap();
        }
        return this.parameters;
    }

    @Override
    public long getRunningDurationInNanos() {
        return this.duration;
    }

    @Override
    public long getDurationInMilliseconds() {
        return TimeUnit.MILLISECONDS.convert(this.getDuration(), TimeUnit.NANOSECONDS);
    }

    @Override
    public long getDuration() {
        return this.duration;
    }

    @Override
    public long getExclusiveDuration() {
        return 0L;
    }

    @Override
    public long getEndTime() {
        return this.startTime + this.duration;
    }

    @Override
    public long getEndTimeInMilliseconds() {
        return TimeUnit.MILLISECONDS.convert(this.getEndTime(), TimeUnit.NANOSECONDS);
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public long getStartTimeInMilliseconds() {
        return TimeUnit.MILLISECONDS.convert(this.getStartTime(), TimeUnit.NANOSECONDS);
    }

    @Override
    public Tracer getParentTracer() {
        return this.parentTracer;
    }

    @Override
    public void setParentTracer(Tracer tracer) {
        this.parentTracer = tracer;
    }

    public String getRequestMetricName() {
        return null;
    }

    protected final void setMetricNameFormat(MetricNameFormat nameFormat) {
        this.metricNameFormat = nameFormat;
    }

    protected final MetricNameFormat getMetricNameFormat() {
        return this.metricNameFormat;
    }

    @Override
    public final String getMetricName() {
        return this.metricNameFormat == null ? null : this.metricNameFormat.getMetricName();
    }

    @Override
    public final String getTransactionSegmentName() {
        return this.metricNameFormat == null ? null : this.metricNameFormat.getTransactionSegmentName();
    }

    @Override
    public final String getTransactionSegmentUri() {
        return this.metricNameFormat == null ? null : this.metricNameFormat.getTransactionSegmentUri();
    }

    @Override
    public Throwable getThrowable() {
        return null;
    }

    protected void recordMetrics(TransactionStats transactionStats) {
        if (this.getTransaction().isIgnore()) {
            return;
        }
        if (this.isMetricProducer()) {
            String metricName = this.getMetricName();
            if (metricName != null) {
                ResponseTimeStats stats = transactionStats.getScopedStats().getResponseTimeStats(metricName);
                stats.recordResponseTimeInNanos(this.getDuration(), this.getExclusiveDuration());
            }
            if (this.getRollupMetricNames() != null) {
                for (String name : this.getRollupMetricNames()) {
                    ResponseTimeStats stats = transactionStats.getUnscopedStats().getResponseTimeStats(name);
                    stats.recordResponseTimeInNanos(this.getDuration(), this.getExclusiveDuration());
                }
            }
            this.doRecordMetrics(transactionStats);
        }
    }

    protected void doRecordMetrics(TransactionStats transactionStats) {
    }

    @Override
    public final boolean isParent() {
        return this.isParent;
    }

    @Override
    public void childTracerFinished(Tracer child) {
        if (child.isMetricProducer() && !(child instanceof SkipTracer) && this.generateTransactionSegment && child.isTransactionSegment()) {
            this.isParent = true;
        }
    }

    @Override
    public ClassMethodSignature getClassMethodSignature() {
        return this.classMethodSignature;
    }

    @Override
    public boolean isTransactionSegment() {
        return this.generateTransactionSegment;
    }

    @Override
    public boolean isMetricProducer() {
        return this.metricProducer;
    }

    @Override
    public TransactionSegment getTransactionSegment(TransactionTracerConfig ttConfig, SqlObfuscator sqlObfuscator, long startTime, TransactionSegment lastSibling) {
        return new TransactionSegment(ttConfig, sqlObfuscator, startTime, this);
    }

    public void setMetricName(String ... metricNameParts) {
        String metricName = Strings.join('/', metricNameParts);
        this.setMetricNameFormat(new SimpleMetricNameFormat(metricName));
    }
}

