/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.async;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.TransactionActivity;
import com.newrelic.agent.TransactionHolder;
import com.newrelic.agent.TransactionStateImpl;
import com.newrelic.agent.async.AsyncTracer;
import com.newrelic.agent.instrumentation.pointcuts.scala.TransactionHolderDispatcherPointCut;
import com.newrelic.agent.stats.TransactionStats;
import com.newrelic.agent.tracers.AbstractTracer;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.tracers.metricname.MetricNameFormat;
import com.newrelic.agent.tracers.metricname.SimpleMetricNameFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncTransactionState
extends TransactionStateImpl {
    private static final String ASYNC_WAIT = "Async Wait";
    private static final ClassMethodSignature ASYNC_WAIT_SIG = new ClassMethodSignature("NR_ASYNC_WAIT_CLASS", "NR_ASYNC_WAIT_METHOD", "()V");
    private static final MetricNameFormat ASYNC_WAIT_FORMAT = new SimpleMetricNameFormat("Async Wait");
    private static final Object[] ASYNC_TRACER_ARGS = new Object[]{176, null};
    private final AtomicBoolean isSuspended = new AtomicBoolean(false);
    private final AtomicBoolean isComplete = new AtomicBoolean(false);
    private final Collection<TransactionActivity> asyncTransactionActivitiesComplete = new ConcurrentLinkedQueue<TransactionActivity>();
    private final Collection<Transaction> asyncTransactions = new ConcurrentLinkedQueue<Transaction>();
    private final Collection<TransactionHolder> asyncJobs = new ConcurrentLinkedQueue<TransactionHolder>();
    private final AtomicReference<TransactionActivity> transactionActivityRef = new AtomicReference();
    private final AtomicReference<Transaction> parentTransactionRef = new AtomicReference();
    private volatile long asyncStartTimeInNanos = -1L;
    private volatile long asyncFinishTimeInNanos = -1L;
    private final AtomicBoolean invalidateAsyncJobs = new AtomicBoolean();

    public AsyncTransactionState(TransactionActivity txa) {
        this(txa, null);
    }

    public AsyncTransactionState(TransactionActivity txa, Transaction parentTransaction) {
        this.transactionActivityRef.set(txa);
        this.parentTransactionRef.set(parentTransaction);
    }

    @Override
    public boolean finish(Transaction tx, Tracer tracer) {
        if (tracer == tx.getRootTracer() && this.isAsync() && !this.isComplete()) {
            this.asyncStartTimeInNanos = System.nanoTime();
            tx.getTransactionActivity().recordCpu();
            Transaction.clearTransaction();
            this.isSuspended.set(true);
            if (Agent.LOG.isFinestEnabled()) {
                Agent.LOG.finest(MessageFormat.format("Suspended transaction {0}", this.transactionActivityRef));
            }
            return false;
        }
        return true;
    }

    boolean isAsync() {
        return !this.asyncJobs.isEmpty() || !this.asyncTransactions.isEmpty();
    }

    private void tryComplete(boolean finishRootTracer) {
        if (this.isAsyncComplete() && this.isComplete.compareAndSet(false, true)) {
            try {
                this.doComplete(finishRootTracer);
            }
            catch (Exception ex) {
                String msg = MessageFormat.format("Failed to complete transaction {0}: {1}", this.transactionActivityRef, ex);
                if (Agent.LOG.isFinestEnabled()) {
                    Agent.LOG.log(Level.FINEST, msg, ex);
                }
                Agent.LOG.finer(msg);
            }
        }
        if (this.parentTransactionRef.get() == null && Agent.LOG.isFinerEnabled()) {
            this.printIncompleteTransactionGraph();
        }
    }

    public boolean isComplete() {
        return this.isComplete.get();
    }

    private boolean isAsyncComplete() {
        return this.asyncJobs.isEmpty() && this.asyncTransactions.isEmpty() && this.isSuspended.get();
    }

    private void doComplete(boolean finishRootTracer) {
        Transaction currentTx = null;
        if (Transaction.hasTransaction()) {
            currentTx = Transaction.getTransaction();
            if (currentTx == this.transactionActivityRef.get().getTransaction()) {
                currentTx = null;
            } else {
                Transaction.clearTransaction();
                Transaction.setTransaction(this.transactionActivityRef.get().getTransaction());
            }
        }
        this.asyncFinishTimeInNanos = System.nanoTime();
        this.completeTransaction(finishRootTracer);
        if (Agent.LOG.isFinestEnabled()) {
            Agent.LOG.finest(MessageFormat.format("Completed transaction {0}", this.transactionActivityRef));
        }
        if (currentTx != null) {
            Transaction.clearTransaction();
            Transaction.setTransaction(currentTx);
        }
    }

    private void completeTransaction(boolean finishRootTracer) {
        Transaction parentTx;
        this.mergeAsyncTransactionData();
        if (finishRootTracer) {
            this.finishTracer((AbstractTracer)this.transactionActivityRef.get().getRootTracer());
        }
        if ((parentTx = this.parentTransactionRef.get()) != null) {
            parentTx.getTransactionState().asyncTransactionFinished(this.transactionActivityRef.get());
        }
    }

    private void mergeAsyncTransactionData() {
        for (TransactionActivity txa : this.asyncTransactionActivitiesComplete) {
            this.mergeAsyncTransactionData(txa);
        }
    }

    private void mergeAsyncTransactionData(TransactionActivity childActivity) {
        if (childActivity == this.transactionActivityRef.get()) {
            Agent.LOG.fine("Cannot merge transaction into itself: " + childActivity);
            return;
        }
        this.mergeStats(childActivity);
        this.mergeParameters(childActivity.getTransaction());
    }

    private void mergeStats(TransactionActivity childActivity) {
        TransactionActivity txa = this.transactionActivityRef.get();
        TransactionStats stats = txa.getTransactionStats();
        stats.getScopedStats().mergeStats(childActivity.getTransactionStats().getScopedStats());
        childActivity.getTransactionStats().getUnscopedStats().getStatsMap().remove("GC/cumulative");
        stats.getUnscopedStats().mergeStats(childActivity.getTransactionStats().getUnscopedStats());
    }

    private void mergeParameters(Transaction tx) {
        Transaction transaction = this.transactionActivityRef.get().getTransaction();
        Long cpuTime = (Long)tx.getIntrinsicAttributes().get("cpu_time");
        if (cpuTime != null) {
            transaction.addTotalCpuTimeForLegacy(cpuTime);
        }
        if (transaction.getUserAttributes().size() + tx.getUserAttributes().size() <= transaction.getAgentConfig().getMaxUserParameters()) {
            transaction.getUserAttributes().putAll(tx.getUserAttributes());
        }
    }

    @Override
    public void mergeAsyncTracers() {
        if (this.asyncTransactionActivitiesComplete.isEmpty()) {
            return;
        }
        TransactionActivity txa = this.transactionActivityRef.get();
        AsyncTracer asyncWaitTracer = new AsyncTracer(txa, ASYNC_WAIT_SIG, ASYNC_WAIT_FORMAT, this.asyncStartTimeInNanos, this.asyncFinishTimeInNanos);
        asyncWaitTracer.put("nr_async_wait", true);
        txa.tracerStarted(asyncWaitTracer);
        this.mergeAsyncTracers(asyncWaitTracer);
        this.finishTracer(asyncWaitTracer);
    }

    private void finishTracer(AbstractTracer tracer) {
        if (tracer != null) {
            tracer.invoke("s", null, ASYNC_TRACER_ARGS);
        }
    }

    private void mergeAsyncTracers(Tracer asyncWaitTracer) {
        for (TransactionActivity txa : this.asyncTransactionActivitiesComplete) {
            this.mergeAsyncTracers(asyncWaitTracer, txa);
        }
        this.asyncTransactionActivitiesComplete.clear();
    }

    private void mergeAsyncTracers(Tracer asyncWaitTracer, TransactionActivity childActivity) {
        if (childActivity == this.transactionActivityRef.get()) {
            Agent.LOG.fine("Cannot merge transaction into itself: " + childActivity);
            return;
        }
        this.mergeTracers(asyncWaitTracer, childActivity);
    }

    private void mergeTracers(Tracer asyncWaitTracer, TransactionActivity childActivity) {
        TransactionActivity txa = this.transactionActivityRef.get();
        Tracer rootTracer = childActivity.getRootTracer();
        rootTracer.setParentTracer(asyncWaitTracer);
        txa.addTracer(rootTracer);
        List<Tracer> tracers = this.getInterestingTracers(childActivity);
        for (Tracer tracer : tracers) {
            txa.addTracer(tracer);
        }
        asyncWaitTracer.childTracerFinished(rootTracer);
    }

    private List<Tracer> getInterestingTracers(TransactionActivity txa) {
        Tracer rootTracer = txa.getRootTracer();
        List<Tracer> tracers = txa.getTransaction().getAllTracers();
        HashSet<Tracer> interestingTracers = new HashSet<Tracer>();
        for (Tracer tracer : tracers) {
            if (!this.isInteresting(tracer.getMetricName())) continue;
            interestingTracers.add(tracer);
            for (Tracer parentTracer = tracer.getParentTracer(); parentTracer != null && parentTracer != rootTracer; parentTracer = parentTracer.getParentTracer()) {
                interestingTracers.add(parentTracer);
            }
        }
        return this.getInterestingTracersInStartOrder(tracers, interestingTracers);
    }

    private boolean isInteresting(String metricName) {
        if (metricName != null) {
            if (metricName.startsWith(ASYNC_WAIT)) {
                return false;
            }
            if (metricName.startsWith("Java/scala.concurrent")) {
                return false;
            }
            if (metricName.startsWith("Java/scala.collection")) {
                return false;
            }
            if (metricName.startsWith("Java/play.api.libs.concurrent")) {
                return false;
            }
            if (metricName.startsWith("Java/play.api.libs.iteratee")) {
                return false;
            }
            if (metricName.startsWith("Java/play.core.server.netty.PlayDefaultUpstreamHandler")) {
                return false;
            }
            if (metricName.startsWith("Java/play.libs.F")) {
                return false;
            }
            if (metricName.startsWith("Java/akka.pattern.PromiseActorRef")) {
                return false;
            }
        }
        return true;
    }

    private List<Tracer> getInterestingTracersInStartOrder(List<Tracer> tracers, Set<Tracer> interestingTracers) {
        ArrayList<Tracer> result = new ArrayList<Tracer>(interestingTracers.size());
        for (Tracer tracer : tracers) {
            if (!interestingTracers.contains(tracer)) continue;
            result.add(tracer);
        }
        return result;
    }

    @Override
    public void asyncTransactionStarted(Transaction tx, TransactionHolder txHolder) {
        if (this.isComplete()) {
            return;
        }
        if (this.transactionActivityRef.get().getTransaction() == tx) {
            Agent.LOG.fine("Cannot start async transaction of itself: " + tx);
            return;
        }
        boolean added = this.addAsyncTransaction(tx);
        if (added && Agent.LOG.isFinestEnabled()) {
            String msg = MessageFormat.format("Async transaction started for {0} by {1}: {2}", this.transactionActivityRef, txHolder, tx);
            Agent.LOG.finest(msg);
        }
    }

    private boolean addAsyncTransaction(Transaction tx) {
        return !this.asyncTransactions.contains(tx) && this.asyncTransactions.add(tx);
    }

    @Override
    public void asyncTransactionFinished(TransactionActivity txa) {
        if (this.isComplete()) {
            return;
        }
        if (this.transactionActivityRef.get() == txa) {
            Agent.LOG.fine("Cannot finish async transaction of itself: " + txa);
            return;
        }
        if (this.asyncTransactions.remove(txa.getTransaction()) && this.asyncTransactionActivitiesComplete.add(txa)) {
            if (Agent.LOG.isFinestEnabled()) {
                String msg = MessageFormat.format("Async transaction finished for {0}: {1} (remaining: {2})", this.transactionActivityRef, txa, this.asyncTransactions);
                Agent.LOG.finest(msg);
            }
            while (this.asyncTransactions.remove(txa)) {
                Agent.LOG.log(Level.FINEST, "Removed the transaction again: " + txa);
            }
        }
        this.tryComplete(true);
    }

    @Override
    public void asyncJobStarted(TransactionHolder job) {
        if (this.isComplete() || this.invalidateAsyncJobs.get()) {
            return;
        }
        if (!this.asyncJobs.contains(job) && this.asyncJobs.add(job) && Agent.LOG.isFinestEnabled()) {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            String msg = MessageFormat.format("Async job started for {0}: {1} ({2})", this.transactionActivityRef, job, Arrays.asList(stackTrace).toString());
            Agent.LOG.finest(msg);
        }
    }

    @Override
    public void asyncJobInvalidate(TransactionHolder job) {
        if (this.isComplete()) {
            return;
        }
        if (this.asyncJobs.remove(job)) {
            if (Agent.LOG.isFinestEnabled()) {
                String msg = MessageFormat.format("Async job removed from transaction. {0}: {1} (remaining: {2})", this.transactionActivityRef, job, this.asyncJobs);
                Agent.LOG.finest(msg);
            }
            this.tryComplete(false);
        }
    }

    @Override
    public void asyncJobFinished(TransactionHolder job) {
        if (this.isComplete()) {
            return;
        }
        if (this.asyncJobs.remove(job)) {
            if (Agent.LOG.isFinestEnabled()) {
                String msg = MessageFormat.format("Async job finished for {0}: {1} (remaining: {2})", this.transactionActivityRef, job, this.asyncJobs);
                Agent.LOG.finest(msg);
            }
            this.tryComplete(job != TransactionHolderDispatcherPointCut.TRANSACTION_HOLDER);
        }
    }

    @Override
    public void setInvalidateAsyncJobs(boolean invalidate) {
        this.invalidateAsyncJobs.set(invalidate);
    }

    public void printIncompleteTransactionGraph() {
        if (Agent.LOG.isFinerEnabled()) {
            Agent.LOG.finer("Job Graph for " + this.transactionActivityRef.get());
            this.printIncompleteTransactionGraph(0);
        }
    }

    private void printIncompleteTransactionGraph(int indentLevel) {
        String indent = "-----------------------------------------------------------------------------------------------------------------------------".substring(0, indentLevel * 2);
        for (Transaction tx : this.asyncTransactions) {
            Agent.LOG.finer(indent + "+ Tx: " + tx + (Transaction.getTransaction() == tx ? " <!>" : ""));
            if (!(tx.getTransactionState() instanceof AsyncTransactionState)) continue;
            AsyncTransactionState transactionState = (AsyncTransactionState)tx.getTransactionState();
            transactionState.printIncompleteTransactionGraph(indentLevel + 1);
        }
        for (TransactionHolder th : this.asyncJobs) {
            if (th._nr_getTransaction() instanceof Transaction) {
                Transaction transaction = (Transaction)th._nr_getTransaction();
                Agent.LOG.finer(indent + "> Job: " + th + " (" + transaction + ")");
                continue;
            }
            Agent.LOG.finer(indent + "> Th: " + th);
        }
    }
}

