/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.attributes;

import com.newrelic.agent.Agent;
import com.newrelic.agent.attributes.AttributesNode;
import com.newrelic.agent.attributes.DestinationPredicate;
import com.newrelic.agent.attributes.RootConfigAttributesNode;
import com.newrelic.agent.deps.com.google.common.cache.CacheBuilder;
import com.newrelic.agent.deps.com.google.common.cache.CacheLoader;
import com.newrelic.agent.deps.com.google.common.cache.LoadingCache;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDestinationPredicate
implements DestinationPredicate {
    private static final long MAX_CACHE_SIZE_BUFFER = 200L;
    private final RootConfigAttributesNode mandatoryExcludeTrie;
    private final RootConfigAttributesNode configTrie;
    private final AttributesNode defaultExcludeTrie;
    private final LoadingCache<String, Boolean> cache;
    private final String destination;

    public DefaultDestinationPredicate(String dest, Set<String> exclude, Set<String> include, Set<String> defaultExcludes, Set<String> mandatoryExclude) {
        this.mandatoryExcludeTrie = DefaultDestinationPredicate.generateExcludeConfigTrie(dest, mandatoryExclude);
        this.configTrie = DefaultDestinationPredicate.generateConfigTrie(dest, exclude, include);
        this.defaultExcludeTrie = DefaultDestinationPredicate.generateDefaultTrie(dest, defaultExcludes);
        this.destination = dest;
        this.cache = CacheBuilder.newBuilder().maximumSize(200L).build(new CacheLoader<String, Boolean>(){

            @Override
            public Boolean load(String key) throws Exception {
                return DefaultDestinationPredicate.this.isIncluded(key);
            }
        });
    }

    private Boolean isIncluded(String key) {
        Boolean output = this.mandatoryExcludeTrie.applyRules(key);
        if (output == null) {
            output = this.configTrie.applyRules(key);
        }
        if (output == null) {
            output = this.defaultExcludeTrie.applyRules(key);
        }
        return output;
    }

    @Override
    public boolean apply(String key) {
        try {
            return this.changeToPrimitiveAndLog(key, this.cache.get(key));
        }
        catch (ExecutionException e) {
            return this.changeToPrimitiveAndLog(key, this.isIncluded(key));
        }
    }

    private void logOutput(String key, boolean value) {
        if (Agent.LOG.isFineEnabled()) {
            Agent.LOG.log(Level.FINER, "{0}: Attribute {1} is {2}", new Object[]{this.destination, key, value ? "enabled" : "disabled"});
        }
    }

    private boolean changeToPrimitiveAndLog(String key, Boolean value) {
        boolean out = value == null ? true : value;
        this.logOutput(key, out);
        return out;
    }

    @Override
    public boolean isPotentialConfigMatch(String key) {
        LinkedList<AttributesNode> queue = new LinkedList<AttributesNode>();
        queue.addAll(this.configTrie.getChildren());
        while (!queue.isEmpty()) {
            AttributesNode node = (AttributesNode)queue.remove(0);
            queue.addAll(node.getChildren());
            if (!node.isIncludeDestination() || !node.mightMatch(key)) continue;
            return true;
        }
        return false;
    }

    protected static AttributesNode generateDefaultTrie(String dest, Set<String> defaultExcludes) {
        AttributesNode root = new AttributesNode("*", true, dest, true);
        for (String current : defaultExcludes) {
            root.addNode(new AttributesNode(current, false, dest, true));
        }
        return root;
    }

    protected static RootConfigAttributesNode generateExcludeConfigTrie(String dest, Set<String> exclude) {
        RootConfigAttributesNode root = new RootConfigAttributesNode(dest);
        DefaultDestinationPredicate.addSpecifcInOrEx(root, false, exclude, dest, true);
        return root;
    }

    protected static RootConfigAttributesNode generateConfigTrie(String dest, Set<String> exclude, Set<String> include) {
        RootConfigAttributesNode root = new RootConfigAttributesNode(dest);
        DefaultDestinationPredicate.addSpecifcInOrEx(root, false, exclude, dest, false);
        DefaultDestinationPredicate.addSpecifcInOrEx(root, true, include, dest, false);
        return root;
    }

    private static void addSpecifcInOrEx(AttributesNode root, boolean isInclude, Set<String> inOrEx, String dest, boolean isDefault) {
        for (String current : inOrEx) {
            root.addNode(new AttributesNode(current, isInclude, dest, isDefault));
        }
    }
}

