/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.Agent;
import com.newrelic.agent.config.BaseConfig;
import com.newrelic.agent.config.ClassTransformerConfig;
import com.newrelic.agent.deps.org.objectweb.asm.Type;
import com.newrelic.agent.instrumentation.annotationmatchers.AnnotationMatcher;
import com.newrelic.agent.instrumentation.annotationmatchers.ClassNameAnnotationMatcher;
import com.newrelic.agent.instrumentation.annotationmatchers.NoMatchAnnotationMatcher;
import com.newrelic.agent.instrumentation.annotationmatchers.OrAnnotationMatcher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ClassTransformerConfigImpl
extends BaseConfig
implements ClassTransformerConfig {
    public static final String ENABLED = "enabled";
    public static final String EXCLUDES = "excludes";
    public static final String INCLUDES = "includes";
    public static final String COMPUTE_FRAMES = "compute_frames";
    public static final String SHUTDOWN_DELAY = "shutdown_delay";
    public static final String GRANT_PACKAGE_ACCESS = "grant_package_access";
    public static final boolean DEFAULT_COMPUTE_FRAMES = true;
    public static final boolean DEFAULT_ENABLED = true;
    public static final int DEFAULT_SHUTDOWN_DELAY = -1;
    public static final boolean DEFAULT_GRANT_PACKAGE_ACCESS = false;
    private static final String SYSTEM_PROPERTY_ROOT = "newrelic.config.class_transformer.";
    static final String NEW_RELIC_TRACE_TYPE_DESC = "Lcom/newrelic/api/agent/Trace;";
    static final String DEPRECATED_NEW_RELIC_TRACE_TYPE_DESC = "Lcom/newrelic/agent/Trace;";
    private final boolean isEnabled;
    private final boolean custom_tracing;
    private final Set<String> excludes;
    private final Set<String> includes;
    private final boolean computeFrames;
    private final long shutdownDelayInNanos;
    private final boolean grantPackageAccess;
    private final AnnotationMatcher ignoreTransactionAnnotationMatcher;
    private final AnnotationMatcher ignoreApdexAnnotationMatcher;
    private final AnnotationMatcher traceAnnotationMatcher;
    public static final String JDBC_STATEMENTS_PROPERTY = "jdbc_statements";

    ClassTransformerConfigImpl(Map<String, Object> props, boolean customTracingEnabled) {
        super(props, SYSTEM_PROPERTY_ROOT);
        this.custom_tracing = customTracingEnabled;
        this.isEnabled = this.getProperty(ENABLED, true);
        this.excludes = Collections.unmodifiableSet(new HashSet<String>(this.getUniqueStrings(EXCLUDES)));
        this.includes = Collections.unmodifiableSet(new HashSet<String>(this.getUniqueStrings(INCLUDES)));
        this.computeFrames = this.getProperty(COMPUTE_FRAMES, true);
        this.shutdownDelayInNanos = this.initShutdownDelay();
        this.grantPackageAccess = this.getProperty(GRANT_PACKAGE_ACCESS, false);
        this.traceAnnotationMatcher = customTracingEnabled ? this.initializeTraceAnnotationMatcher(props) : new NoMatchAnnotationMatcher();
        this.ignoreTransactionAnnotationMatcher = new ClassNameAnnotationMatcher("NewRelicIgnoreTransaction", false);
        this.ignoreApdexAnnotationMatcher = new ClassNameAnnotationMatcher("NewRelicIgnoreApdex", false);
    }

    private AnnotationMatcher initializeTraceAnnotationMatcher(Map<?, ?> props) {
        ArrayList<AnnotationMatcher> matchers = new ArrayList<AnnotationMatcher>();
        matchers.add(new ClassNameAnnotationMatcher(Type.getType(DEPRECATED_NEW_RELIC_TRACE_TYPE_DESC).getDescriptor()));
        matchers.add(new ClassNameAnnotationMatcher(Type.getType(NEW_RELIC_TRACE_TYPE_DESC).getDescriptor()));
        String traceAnnotationClassName = (String)this.getProperty("trace_annotation_class_name");
        if (traceAnnotationClassName == null) {
            matchers.add(new ClassNameAnnotationMatcher("NewRelicTrace", false));
        } else {
            final HashSet<String> names = new HashSet<String>();
            for (String name : traceAnnotationClassName.split(",")) {
                Agent.LOG.fine("Adding " + name + " as a Trace annotation");
                names.add(ClassTransformerConfigImpl.internalizeName(name));
            }
            matchers.add(new AnnotationMatcher(){

                public boolean matches(String annotationDesc) {
                    return names.contains(annotationDesc);
                }
            });
        }
        return OrAnnotationMatcher.getOrMatcher(matchers.toArray(new AnnotationMatcher[0]));
    }

    static String internalizeName(String name) {
        return 'L' + name.trim().replace('.', '/') + ';';
    }

    private long initShutdownDelay() {
        int shutdownDelayInSeconds = this.getIntProperty(SHUTDOWN_DELAY, -1);
        if (shutdownDelayInSeconds > 0) {
            return TimeUnit.NANOSECONDS.convert(shutdownDelayInSeconds, TimeUnit.SECONDS);
        }
        return -1L;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public boolean isCustomTracingEnabled() {
        return this.custom_tracing;
    }

    @Override
    public Set<String> getIncludes() {
        return this.includes;
    }

    @Override
    public Set<String> getExcludes() {
        return this.excludes;
    }

    @Override
    public boolean computeFrames() {
        return this.computeFrames;
    }

    @Override
    public boolean isGrantPackageAccess() {
        return this.grantPackageAccess;
    }

    @Override
    public long getShutdownDelayInNanos() {
        return this.shutdownDelayInNanos;
    }

    @Override
    public final AnnotationMatcher getIgnoreTransactionAnnotationMatcher() {
        return this.ignoreTransactionAnnotationMatcher;
    }

    @Override
    public final AnnotationMatcher getIgnoreApdexAnnotationMatcher() {
        return this.ignoreApdexAnnotationMatcher;
    }

    @Override
    public AnnotationMatcher getTraceAnnotationMatcher() {
        return this.traceAnnotationMatcher;
    }

    @Override
    public Collection<String> getJdbcStatements() {
        String jdbcStatementsProp = (String)this.getProperty(JDBC_STATEMENTS_PROPERTY);
        if (jdbcStatementsProp == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(jdbcStatementsProp.split(",[\\s]*"));
    }

    static ClassTransformerConfig createClassTransformerConfig(Map<String, Object> settings, boolean custom_tracing) {
        if (settings == null) {
            settings = Collections.emptyMap();
        }
        return new ClassTransformerConfigImpl(settings, custom_tracing);
    }
}

