/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.database;

import com.newrelic.agent.Agent;
import com.newrelic.agent.database.RecordSql;
import com.newrelic.agent.deps.com.google.common.collect.ImmutableSet;
import com.newrelic.agent.deps.org.json.simple.JSONArray;
import com.newrelic.agent.deps.org.json.simple.parser.JSONParser;
import com.newrelic.agent.deps.org.json.simple.parser.ParseException;
import com.newrelic.agent.tracers.metricname.MetricNameFormat;
import com.newrelic.agent.tracers.metricname.SimpleMetricNameFormat;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DatabaseVendor {
    MYSQL("MySQL", "mysql", true, "^jdbc:mysql://([^/]*)/([^/\\?]*).*"),
    ORACLE("Oracle", "oracle", false, "^jdbc:oracle:(thin|oci):(@//|@)([^:]*:\\d+)(/|:)(.*)"){

        protected String getHost(Matcher matcher) {
            return matcher.group(3);
        }

        protected String getDatabase(Matcher matcher) {
            return matcher.group(5);
        }
    }
    ,
    MICROSOFT("Microsoft SQL Server", "sqlserver", false, "^jdbc:sqlserver://([^;]*).*"),
    POSTGRES("PostgreSQL", "postgresql", true, "^jdbc:postgresql://([^/]*)/([^\\?]*).*"){
        private final Set<String> EXPLAIN_WHITELIST = ImmutableSet.of("Plan", "Plans", "Node Type", "Relation Name", "Alias", "Startup Cost", new String[]{"Total Cost", "Plan Rows", "Plan Width", "Parent Relationship", "Join Type", "Group Key", "Sort Key", "Relation Name", "Sort Method", "Sort Space Used", "Sort Space Type", "Scan Direction", "Index Name", "Actual Startup Time", "Actual Total Time", "Actual Rows", "Actual Loops", "Triggers", "Total Runtime", "Strategy"});

        @Override
        public String getHost(String url) {
            Matcher matcher = POSTGRES_URL_PATTERN.matcher(url);
            if (matcher.matches()) {
                return matcher.group(1);
            }
            if (POSTGRES_URL_PATTERN_DB.matcher(url).matches()) {
                return "localhost";
            }
            return super.getHost(url);
        }

        @Override
        public String getExplainPlanSql(String sql) throws SQLException {
            return "EXPLAIN (FORMAT JSON) " + sql;
        }

        @Override
        public String getExplainPlanFormat() {
            return "json";
        }

        @Override
        public Collection<Collection<Object>> parseExplainPlanResultSet(int columnCount, ResultSet rs, RecordSql recordSql) throws SQLException {
            if (rs.next()) {
                String json = rs.getObject(1).toString();
                try {
                    JSONArray parse = (JSONArray)new JSONParser().parse(json);
                    if (RecordSql.obfuscated.equals((Object)recordSql)) {
                        this.scrubPlan((Map)parse.get(0));
                    }
                    return Arrays.asList(parse);
                }
                catch (ParseException e) {
                    Agent.LOG.log(Level.FINER, "Unable to parse explain plan: {0}", new Object[]{e.toString()});
                    return Arrays.asList(Arrays.asList("Unable to parse explain plan"));
                }
            }
            return Arrays.asList(Arrays.asList("No rows were returned by the explain plan"));
        }

        private void scrubPlan(Map<String, Object> plan) {
            Map innerPlan = (Map)plan.get("Plan");
            if (innerPlan != null) {
                this.scrubPlan(innerPlan);
            } else {
                JSONArray plans = (JSONArray)plan.get("Plans");
                if (plans != null) {
                    for (Object childPlan : plans) {
                        this.scrubPlan((Map)childPlan);
                    }
                }
            }
            for (Map.Entry<String, Object> entry : plan.entrySet()) {
                if (this.EXPLAIN_WHITELIST.contains(entry.getKey())) continue;
                entry.setValue("?");
            }
        }
    }
    ,
    DB2("DB2", "db2", false, "jdbc:db2://server:port/database"){

        public String getHost(String url) {
            String tmp = url.substring("jdbc:db2:".length());
            if (tmp.indexOf("//") != 0) {
                return "LocalHost";
            }
            tmp = tmp.substring(2);
            int index = tmp.indexOf(47);
            return tmp.substring(0, index);
        }
    }
    ,
    DERBY("Apache Derby", "derby", false, "^$"),
    UNKNOWN("Unknown", null, false, "^$");

    private static final String UNKNOWN_STRING = "Unknown";
    private static final String REMOTE_SERVICE_DATABASE_METRIC_NAME = "RemoteService/Database/{0}/{1}/{2}/{3}/all";
    public static final MetricNameFormat UNKNOWN_DATABASE_METRIC_NAME;
    static final Pattern POSTGRES_URL_PATTERN;
    static final Pattern POSTGRES_URL_PATTERN_DB;
    private static final Pattern SIMPLE_DB_URL;
    private static final Pattern TYPE_PATTERN;
    private static final Map<String, DatabaseVendor> TYPE_TO_VENDOR;
    private final String name;
    final boolean explainPlanSupported;
    final Pattern urlPattern;
    final String type;

    private DatabaseVendor(String name, String type, boolean explainSupported, String urlPattern) {
        this.name = name;
        this.explainPlanSupported = explainSupported;
        this.type = type;
        this.urlPattern = Pattern.compile(urlPattern);
    }

    public String getName() {
        return this.name;
    }

    public boolean isExplainPlanSupported() {
        return this.explainPlanSupported;
    }

    public String getExplainPlanSql(String sql) throws SQLException {
        if (!this.isExplainPlanSupported()) {
            throw new SQLException("Unable to run explain plans for " + this.getName() + " databases");
        }
        return "EXPLAIN " + sql;
    }

    public static DatabaseVendor getDatabaseVendor(String url) {
        DatabaseVendor vendor;
        String type;
        Matcher matcher = TYPE_PATTERN.matcher(url);
        if (matcher.matches() && (type = matcher.group(1)) != null && (vendor = TYPE_TO_VENDOR.get(type)) != null) {
            return vendor;
        }
        return UNKNOWN;
    }

    public String getType() {
        return this.type;
    }

    public String getHost(String url) {
        String host;
        Matcher matcher = this.urlPattern.matcher(url);
        if (matcher.matches() && (host = this.getHost(matcher)) != null) {
            return host;
        }
        if (SIMPLE_DB_URL.matcher(url).matches()) {
            return "localhost";
        }
        return "UnknownOrLocalhost";
    }

    protected String getHost(Matcher matcher) {
        if (matcher.groupCount() >= 1) {
            return matcher.group(1);
        }
        return null;
    }

    public String getDatabase(String url) {
        String db;
        Matcher matcher = this.urlPattern.matcher(url);
        if (matcher.matches() && (db = this.getDatabase(matcher)) != null) {
            return db;
        }
        matcher = SIMPLE_DB_URL.matcher(url);
        if (matcher.matches()) {
            return matcher.group(2);
        }
        return UNKNOWN_STRING;
    }

    protected String getDatabase(Matcher matcher) {
        if (matcher.groupCount() >= 2) {
            return matcher.group(2);
        }
        return null;
    }

    public MetricNameFormat getDatabaseMetricName(DatabaseMetaData metaData) {
        String databaseProductVersion = UNKNOWN_STRING;
        String databaseProductName = UNKNOWN_STRING;
        String host = UNKNOWN_STRING;
        String databaseName = UNKNOWN_STRING;
        if (metaData != null) {
            try {
                databaseProductVersion = metaData.getDatabaseProductVersion();
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                databaseProductName = metaData.getDatabaseProductName();
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                String url = metaData.getURL();
                host = this.getHost(url);
                databaseName = this.getDatabase(url);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return new SimpleMetricNameFormat(MessageFormat.format(REMOTE_SERVICE_DATABASE_METRIC_NAME, databaseProductName, databaseProductVersion, host, databaseName));
    }

    public Collection<Collection<Object>> parseExplainPlanResultSet(int columnCount, ResultSet rs, RecordSql recordSql) throws SQLException {
        LinkedList<Collection<Object>> explains = new LinkedList<Collection<Object>>();
        while (rs.next()) {
            LinkedList<String> values = new LinkedList<String>();
            for (int i = 1; i <= columnCount; ++i) {
                Object obj = rs.getObject(i);
                values.add(obj == null ? "" : obj.toString());
            }
            explains.add(values);
        }
        return explains;
    }

    public String getExplainPlanFormat() {
        return "text";
    }

    static {
        UNKNOWN_DATABASE_METRIC_NAME = new SimpleMetricNameFormat(MessageFormat.format(REMOTE_SERVICE_DATABASE_METRIC_NAME, UNKNOWN_STRING, UNKNOWN_STRING, UNKNOWN_STRING, UNKNOWN_STRING));
        POSTGRES_URL_PATTERN = Pattern.compile("^jdbc:postgresql://([^/]*).*");
        POSTGRES_URL_PATTERN_DB = Pattern.compile("^jdbc:postgresql:(.*)");
        SIMPLE_DB_URL = Pattern.compile("jdbc:([^:]*):([^/;:].*)");
        TYPE_PATTERN = Pattern.compile("jdbc:([^:]*).*");
        TYPE_TO_VENDOR = new HashMap<String, DatabaseVendor>(7);
        for (DatabaseVendor vendor : DatabaseVendor.values()) {
            TYPE_TO_VENDOR.put(vendor.getType(), vendor);
        }
    }
}

