/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.deadlock;

import com.newrelic.agent.deadlock.DeadLockDetector;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.util.DefaultThreadFactory;
import com.newrelic.agent.util.SafeWrappers;
import java.text.MessageFormat;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class DeadlockDetectorService
extends AbstractService {
    private static final String DEADLOCK_DETECTOR_THREAD_NAME = "New Relic Deadlock Detector";
    private static final long INITIAL_DELAY_IN_SECONDS = 300L;
    private static final long SUBSEQUENT_DELAY_IN_SECONDS = 300L;
    private final ScheduledExecutorService scheduledExecutor;
    private volatile ScheduledFuture<?> deadlockTask;

    public DeadlockDetectorService() {
        super(DeadlockDetectorService.class.getSimpleName());
        DefaultThreadFactory threadFactory = new DefaultThreadFactory(DEADLOCK_DETECTOR_THREAD_NAME, true);
        this.scheduledExecutor = Executors.newSingleThreadScheduledExecutor(threadFactory);
    }

    protected void doStart() {
        final DeadLockDetector deadlockDetector = this.getDeadlockDetector();
        try {
            deadlockDetector.detectDeadlockedThreads();
        }
        catch (Throwable t) {
            this.logger.log(Level.FINE, t, "Failed to detect deadlocked threads: {0}.  The Deadlock detector is disabled.", new Object[]{t.toString()});
            this.logger.log(Level.FINEST, t, t.toString(), new Object[0]);
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    deadlockDetector.detectDeadlockedThreads();
                }
                catch (Throwable t) {
                    String msg = MessageFormat.format("Failed to detect deadlocked threads: {0}", t.toString());
                    if (DeadlockDetectorService.this.getLogger().isLoggable(Level.FINER)) {
                        DeadlockDetectorService.this.getLogger().log(Level.WARNING, msg, t);
                    }
                    DeadlockDetectorService.this.getLogger().warning(msg);
                }
            }
        };
        this.deadlockTask = this.scheduledExecutor.scheduleWithFixedDelay(SafeWrappers.safeRunnable(runnable), 300L, 300L, TimeUnit.SECONDS);
    }

    protected void doStop() {
        if (this.deadlockTask != null) {
            this.deadlockTask.cancel(false);
        }
        this.scheduledExecutor.shutdown();
    }

    public boolean isEnabled() {
        return true;
    }

    private DeadLockDetector getDeadlockDetector() {
        return new DeadLockDetector();
    }
}

