/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.extension;

import com.newrelic.agent.deps.org.yaml.snakeyaml.Loader;
import com.newrelic.agent.deps.org.yaml.snakeyaml.Yaml;
import com.newrelic.agent.deps.org.yaml.snakeyaml.constructor.Constructor;
import com.newrelic.agent.extension.ConfigurationConstruct;
import com.newrelic.agent.extension.Extension;
import com.newrelic.agent.extension.XmlExtension;
import com.newrelic.agent.extension.YamlExtension;
import com.newrelic.agent.extension.dom.ExtensionDomParser;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionParsers {
    private final ExtensionParser yamlParser;
    private final ExtensionParser xmlParser;

    public ExtensionParsers(final List<ConfigurationConstruct> constructs) {
        Constructor constructor = new Constructor(){
            {
                for (ConfigurationConstruct construct : constructs) {
                    this.yamlConstructors.put(construct.getName(), construct);
                }
            }
        };
        Loader loader = new Loader(constructor);
        final Yaml yaml = new Yaml(loader);
        this.yamlParser = new ExtensionParser(){

            public Extension parse(ClassLoader classloader, InputStream inputStream, boolean custom) throws Exception {
                Object config = yaml.load(inputStream);
                if (config instanceof Map) {
                    return new YamlExtension(classloader, (Map)config, custom);
                }
                throw new Exception("Invalid yaml extension");
            }
        };
        this.xmlParser = new ExtensionParser(){

            public Extension parse(ClassLoader classloader, InputStream inputStream, boolean custom) throws Exception {
                com.newrelic.agent.extension.beans.Extension ext = ExtensionDomParser.readFile(inputStream);
                return new XmlExtension(this.getClass().getClassLoader(), ext.getName(), ext, custom);
            }
        };
    }

    public ExtensionParser getParser(String fileName) {
        if (fileName.endsWith(".yml")) {
            return this.yamlParser;
        }
        return this.xmlParser;
    }

    public ExtensionParser getXmlParser() {
        return this.xmlParser;
    }

    public ExtensionParser getYamlParser() {
        return this.yamlParser;
    }

    public static interface ExtensionParser {
        public Extension parse(ClassLoader var1, InputStream var2, boolean var3) throws Exception;
    }
}

