/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.extension;

import com.newrelic.agent.deps.com.google.common.collect.ImmutableSet;
import com.newrelic.agent.deps.org.objectweb.asm.ClassReader;
import com.newrelic.agent.deps.org.objectweb.asm.ClassWriter;
import com.newrelic.agent.deps.org.objectweb.asm.commons.RemappingClassAdapter;
import com.newrelic.agent.extension.DependencyRemapper;
import com.newrelic.agent.util.Streams;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;

public class ExtensionRewriter {
    static final DependencyRemapper REMAPPER = new DependencyRemapper(ImmutableSet.of("com/newrelic/agent/deps/org/objectweb/asm/", "com/newrelic/agent/deps/com/google/", "com/newrelic/agent/deps/org/apache/commons/"));

    private ExtensionRewriter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] rewrite(JarFile jar) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        JarOutputStream jarOut = new JarOutputStream(out);
        boolean modified = false;
        try {
            Enumeration<JarEntry> e = jar.entries();
            while (e.hasMoreElements()) {
                Object var12_11;
                JarEntry entry = e.nextElement();
                JarEntry newEntry = new JarEntry(entry.getName());
                InputStream inputStream = jar.getInputStream(entry);
                try {
                    if (entry.getName().endsWith(".class")) {
                        ClassReader cr = new ClassReader(inputStream);
                        ClassWriter writer = new ClassWriter(2);
                        RemappingClassAdapter cv = new RemappingClassAdapter(writer, REMAPPER);
                        cr.accept(cv, 4);
                        if (!REMAPPER.getRemappings().isEmpty()) {
                            modified = true;
                        }
                        inputStream.close();
                        inputStream = new ByteArrayInputStream(writer.toByteArray());
                    }
                    jarOut.putNextEntry(newEntry);
                    Streams.copy(inputStream, jarOut);
                    var12_11 = null;
                }
                catch (Throwable throwable) {
                    var12_11 = null;
                    jarOut.closeEntry();
                    inputStream.close();
                    throw throwable;
                }
                jarOut.closeEntry();
                inputStream.close();
                {
                }
            }
            Object var14_13 = null;
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            jarOut.close();
            jar.close();
            out.close();
            throw throwable;
        }
        jarOut.close();
        jar.close();
        out.close();
        return modified ? out.toByteArray() : null;
    }
}

