/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.extension.beans;

import com.newrelic.agent.deps.org.objectweb.asm.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MethodConverterUtility {
    private static final String BEGIN_PARENTH_FOR_DESCRIPTOR = "(";
    private static final String END_PARENTH_FOR_DESCRIPTOR = ")";
    private static final String ARRAY_NOTATIOM = "[";
    private static final Pattern ARRAY_PATTERN = Pattern.compile("(.+?)((\\[\\])+)\\z");
    private static final Pattern BRACKETS = Pattern.compile("(\\[\\])");
    private static final String COLLECTION_TYPE_REGEX = "<.+?>";

    private MethodConverterUtility() {
    }

    private static String convertParamToDescriptorFormat(String inputParam) {
        Type paramType;
        if (inputParam == null) {
            throw new RuntimeException("The input parameter can not be null.");
        }
        if (Type.BOOLEAN_TYPE.getClassName().equals(inputParam)) {
            paramType = Type.BOOLEAN_TYPE;
        } else if (Type.BYTE_TYPE.getClassName().equals(inputParam)) {
            paramType = Type.BYTE_TYPE;
        } else if (Type.CHAR_TYPE.getClassName().equals(inputParam)) {
            paramType = Type.CHAR_TYPE;
        } else if (Type.DOUBLE_TYPE.getClassName().equals(inputParam)) {
            paramType = Type.DOUBLE_TYPE;
        } else if (Type.FLOAT_TYPE.getClassName().equals(inputParam)) {
            paramType = Type.FLOAT_TYPE;
        } else if (Type.INT_TYPE.getClassName().equals(inputParam)) {
            paramType = Type.INT_TYPE;
        } else if (Type.LONG_TYPE.getClassName().equals(inputParam)) {
            paramType = Type.LONG_TYPE;
        } else if (Type.SHORT_TYPE.getClassName().equals(inputParam)) {
            paramType = Type.SHORT_TYPE;
        } else {
            Matcher arrayMatcher = ARRAY_PATTERN.matcher(inputParam);
            if (arrayMatcher.matches()) {
                String typeName = arrayMatcher.group(1);
                String brackets = arrayMatcher.group(2);
                return MethodConverterUtility.makeArrayType(typeName, brackets);
            }
            if (inputParam.contains(ARRAY_NOTATIOM)) {
                throw new RuntimeException("Brackets should only be in the parameter name if it is an array. Name: " + inputParam);
            }
            String output = inputParam.replace(".", "/").replaceAll(COLLECTION_TYPE_REGEX, "");
            paramType = Type.getObjectType(output);
        }
        return paramType.getDescriptor();
    }

    private static String makeArrayType(String paramType, String brackets) {
        Matcher mms = BRACKETS.matcher(brackets);
        int count = 0;
        while (mms.find()) {
            ++count;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            sb.append(ARRAY_NOTATIOM);
        }
        sb.append(MethodConverterUtility.convertParamToDescriptorFormat(paramType));
        return sb.toString();
    }

    protected static String paramNamesToParamDescriptor(List<String> inputParameters) {
        if (inputParameters == null) {
            return "()";
        }
        ArrayList<String> descriptors = new ArrayList<String>();
        for (String param : inputParameters) {
            descriptors.add(MethodConverterUtility.convertParamToDescriptorFormat(param.trim()));
        }
        return MethodConverterUtility.convertToParmDescriptor(descriptors);
    }

    private static String convertToParmDescriptor(List<String> paramDescriptors) {
        StringBuilder sb = new StringBuilder();
        sb.append(BEGIN_PARENTH_FOR_DESCRIPTOR);
        if (paramDescriptors != null && !paramDescriptors.isEmpty()) {
            for (String param : paramDescriptors) {
                if (Type.getType(param) == null) {
                    throw new RuntimeException("The generated parameter descriptor is invalid. Name: " + param);
                }
                sb.append(param);
            }
        }
        sb.append(END_PARENTH_FOR_DESCRIPTOR);
        return sb.toString();
    }
}

