/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.classmatchers;

import com.newrelic.agent.deps.org.objectweb.asm.ClassReader;
import com.newrelic.agent.deps.org.objectweb.asm.Type;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.OrClassMatcher;
import com.newrelic.agent.util.Strings;
import java.util.Arrays;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExactClassMatcher
extends ClassMatcher {
    private final Type type;
    private final String className;
    private final String internalName;

    public ExactClassMatcher(String className) {
        this.type = Type.getObjectType(Strings.fixInternalClassName(className));
        this.className = this.type.getClassName();
        this.internalName = this.type.getInternalName();
    }

    @Override
    public boolean isMatch(ClassLoader loader, ClassReader cr) {
        return cr.getClassName().equals(this.internalName);
    }

    @Override
    public boolean isMatch(Class<?> clazz) {
        return clazz.getName().equals(this.className);
    }

    public static ClassMatcher or(String ... classNames) {
        return OrClassMatcher.createClassMatcher(classNames);
    }

    public String getInternalClassName() {
        return this.internalName;
    }

    @Override
    public boolean isExactClassMatcher() {
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExactClassMatcher other = (ExactClassMatcher)obj;
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    public String toString() {
        return "ExactClassMatcher(" + this.internalName + ")";
    }

    @Override
    public Collection<String> getClassNames() {
        return Arrays.asList(this.internalName);
    }
}

