/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.custom;

import com.newrelic.agent.Agent;
import com.newrelic.agent.deps.com.google.common.collect.Lists;
import com.newrelic.agent.deps.org.objectweb.asm.commons.Method;
import com.newrelic.agent.instrumentation.classmatchers.OptimizedClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.OptimizedClassMatcherBuilder;
import com.newrelic.agent.instrumentation.context.ClassMatchVisitorFactory;
import com.newrelic.agent.instrumentation.context.ContextClassTransformer;
import com.newrelic.agent.instrumentation.context.InstrumentationContext;
import com.newrelic.agent.instrumentation.context.InstrumentationContextManager;
import com.newrelic.agent.instrumentation.custom.ExtensionClassAndMethodMatcher;
import com.newrelic.agent.instrumentation.tracing.TraceDetails;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomClassTransformer
implements ContextClassTransformer {
    final List<ExtensionClassAndMethodMatcher> extensionPointCuts;
    private final InstrumentationContextManager contextManager;
    private final ClassMatchVisitorFactory matcher;

    public CustomClassTransformer(InstrumentationContextManager contextManager, List<ExtensionClassAndMethodMatcher> extensionPointCuts) {
        this.extensionPointCuts = extensionPointCuts;
        this.matcher = OptimizedClassMatcherBuilder.newBuilder().addClassMethodMatcher(extensionPointCuts.toArray(new ExtensionClassAndMethodMatcher[0])).build();
        contextManager.addContextClassTransformer(this.matcher, this);
        this.contextManager = contextManager;
    }

    public void destroy() {
        this.contextManager.removeMatchVisitor(this.matcher);
    }

    public ClassMatchVisitorFactory getMatcher() {
        return this.matcher;
    }

    @Override
    public byte[] transform(ClassLoader pLoader, String pClassName, Class<?> pClassBeingRedefined, ProtectionDomain pProtectionDomain, byte[] pClassfileBuffer, InstrumentationContext pContext, OptimizedClassMatcher.Match match) throws IllegalClassFormatException {
        block2: {
            try {
                this.addMatchesToTraces(pContext, match);
            }
            catch (Throwable t) {
                Agent.LOG.log(Level.FINE, MessageFormat.format("Unable to transform class {0}", pClassName));
                if (!Agent.LOG.isFinestEnabled()) break block2;
                Agent.LOG.log(Level.FINEST, MessageFormat.format("Unable to transform class {0}", pClassName), t);
            }
        }
        return null;
    }

    private void addMatchesToTraces(InstrumentationContext pContext, OptimizedClassMatcher.Match match) {
        ArrayList<ExtensionClassAndMethodMatcher> matches = Lists.newArrayList(this.extensionPointCuts);
        matches.retainAll(match.getClassMatches().keySet());
        if (!matches.isEmpty()) {
            for (ExtensionClassAndMethodMatcher pc : matches) {
                for (Method m : match.getMethods()) {
                    TraceDetails td;
                    if (!pc.getMethodMatcher().matches(-1, m.getName(), m.getDescriptor(), match.getMethodAnnotations(m))) continue;
                    Method method = pContext.getBridgeMethods().get(m);
                    if (method != null) {
                        m = method;
                    }
                    if ((td = pc.getTraceDetails()).ignoreTransaction()) {
                        if (Agent.LOG.isFinerEnabled()) {
                            Agent.LOG.log(Level.FINER, MessageFormat.format("Matched method {0} for ignoring the transaction trace.", m.toString()));
                        }
                        pContext.addIgnoreTransactionMethod(m);
                        continue;
                    }
                    if (Agent.LOG.isFinerEnabled()) {
                        Agent.LOG.log(Level.FINER, MessageFormat.format("Matched method {0} for instrumentation.", m.toString()));
                    }
                    pContext.addTrace(m, td);
                }
            }
        }
    }
}

