/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.amazon;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.methodmatchers.ExactMethodMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.instrumentation.pointcuts.amazon.AbstractJetS3tPointCut;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.ExternalComponentTracer;
import com.newrelic.agent.tracers.Tracer;
import java.text.MessageFormat;
import java.util.logging.Level;

@PointCut
public class JetS3tPointCut
extends AbstractJetS3tPointCut {
    public JetS3tPointCut(ClassTransformer classTransformer) {
        super(JetS3tPointCut.class, new ExactMethodMatcher("listAllBuckets", "()[Lorg/jets3t/service/model/S3Bucket;"));
    }

    public Tracer getTracer(Transaction transaction, ClassMethodSignature sig, Object service, Object[] args) {
        String uri;
        String host;
        try {
            host = this.getHost(service);
            uri = this.getUri(service);
        }
        catch (Exception e) {
            host = "storage";
            uri = "";
            String msg = MessageFormat.format("Instrumentation error invoking {0} in {1}: {2}", sig, this.getClass().getName(), e);
            if (Agent.LOG.isLoggable(Level.FINEST)) {
                Agent.LOG.log(Level.FINEST, msg, e);
            }
            Agent.LOG.log(Level.FINE, msg);
        }
        return new ExternalComponentTracer(transaction, sig, service, host, "Jets3t", uri, sig.getMethodName());
    }
}

